/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference;

import io.crate.common.collections.Maps;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.reference.Doc;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.doc.lucene.StoredRow;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import java.util.List;
import java.util.Map;

public final class DocRefResolver
implements ReferenceResolver<CollectExpression<Doc, ?>> {
    private final List<ColumnIdent> partitionedByColumns;

    public DocRefResolver(List<ColumnIdent> partitionedByColumns) {
        this.partitionedByColumns = partitionedByColumns;
    }

    @Override
    public CollectExpression<Doc, ?> getImplementation(Reference ref) {
        String fqn;
        ColumnIdent columnIdent = ref.column();
        switch (fqn = columnIdent.fqn()) {
            case "_version": {
                return NestableCollectExpression.forFunction(Doc::getVersion);
            }
            case "_seq_no": {
                return NestableCollectExpression.forFunction(Doc::getSeqNo);
            }
            case "_primary_term": {
                return NestableCollectExpression.forFunction(Doc::getPrimaryTerm);
            }
            case "_id": {
                return NestableCollectExpression.forFunction(Doc::getId);
            }
            case "_docid": {
                return NestableCollectExpression.forFunction(Doc::docId);
            }
            case "_raw": {
                return NestableCollectExpression.forFunction(Doc::getRaw);
            }
            case "_doc": {
                return NestableCollectExpression.forFunction(Doc::getSource);
            }
        }
        ColumnIdent column = columnIdent.name().equals("_doc") ? columnIdent.shiftRight() : columnIdent;
        for (int i = 0; i < this.partitionedByColumns.size(); ++i) {
            ColumnIdent pColumn = this.partitionedByColumns.get(i);
            if (pColumn.equals(column)) {
                int idx = i;
                return NestableCollectExpression.forFunction(getResp -> ref.valueType().implicitCast(getResp.getPartitionValues().get(idx)));
            }
            if (!pColumn.isChildOf(column)) continue;
            int idx = i;
            return NestableCollectExpression.forFunction(response -> {
                if (response == null) {
                    return null;
                }
                String partitionValue = response.getPartitionValues().get(idx);
                Map<String, Object> source = response.getSource();
                Maps.mergeInto(source, (String)pColumn.name(), pColumn.path(), (Object)partitionValue);
                Object value = StoredRow.extractValue(source, column);
                return ref.valueType().implicitCast(value);
            });
        }
        return NestableCollectExpression.forFunction(response -> {
            if (response == null) {
                return null;
            }
            return ref.valueType().sanitizeValue(StoredRow.extractValue(response.getSource(), column));
        });
    }
}

