/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.expression.reference.doc.lucene.BinaryColumnReference;
import io.crate.sql.tree.BitString;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.lucene.util.BytesRef;

public class BitStringColumnReference
extends BinaryColumnReference<BitString> {
    private final int length;

    public BitStringColumnReference(String columnName, int length) {
        super(columnName);
        this.length = length;
    }

    @Override
    protected BitString convert(BytesRef input) {
        ByteBuffer buffer = ByteBuffer.wrap(input.bytes, input.offset, input.length);
        return new BitString(BitSet.valueOf(buffer), this.length);
    }
}

