/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.common.collections.Maps;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.types.ArrayType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.Version;

public class ColumnFieldVisitor
extends StoredFieldVisitor {
    private static final Comparator<Record> CMP_RECORD = new Comparator<Record>(){

        @Override
        public int compare(Record o1, Record o2) {
            return o1.column.compareTo(o2.column);
        }
    };
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private final SourceParser storedSourceParser;
    private final Version shardVersion;
    private ArrayList<Record> records = new ArrayList();

    public ColumnFieldVisitor(DocTableInfo table, Version shardVersionCreated) {
        this.storedSourceParser = new SourceParser(table.lookupNameBySourceKey(), true);
        this.shardVersion = shardVersionCreated;
    }

    public void registerRef(Reference ref) {
        ColumnIdent column = ref.column();
        if (column.name().equals("_doc")) {
            column = column.shiftRight();
        }
        Object storageName = ref.storageIdentLeafName();
        if (ref.valueType() instanceof ArrayType) {
            storageName = "_array_values_" + (String)storageName;
        }
        this.fields.put((String)storageName, new Field(ref.valueType().storageSupportSafe(), column));
    }

    public boolean shouldLoadStoredFields() {
        return !this.fields.isEmpty();
    }

    public void reset() {
        this.records = new ArrayList(this.records.size());
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return this.fields.containsKey(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        Object v = field.decode(this.storedSourceParser, this.shardVersion, value);
        this.records.add(new Record(field.column, v));
    }

    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.records.add(new Record(field.column, value));
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.records.add(new Record(field.column, field.decode(value)));
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.records.add(new Record(field.column, field.decode(value)));
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.records.add(new Record(field.column, Float.valueOf(value)));
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.records.add(new Record(field.column, value));
    }

    public Map<String, Object> getDocMap() {
        HashMap<String, Object> docMap = HashMap.newHashMap(this.records.size());
        this.records.sort(CMP_RECORD);
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = this.records.get(i);
            Maps.mergeInto(docMap, (String)record.column.name(), record.column.path(), (Object)record.value);
        }
        return docMap;
    }

    private record Field(StorageSupport<?> storageSupport, ColumnIdent column) {
        public Object decode(SourceParser sourceParser, Version tableVersion, byte[] v) {
            return this.storageSupport.decode(this.column, sourceParser, tableVersion, v);
        }

        public Object decode(long v) {
            return this.storageSupport.decode(v);
        }

        public Object decode(int v) {
            return this.storageSupport.decode(v);
        }
    }

    private record Record(ColumnIdent column, Object value) {
    }
}

