/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;

public class FloatVectorColumnReference
extends LuceneCollectorExpression<float[]> {
    private final String fqn;
    private BinaryDocValues docValues;
    private int doc;

    public FloatVectorColumnReference(String fqn) {
        this.fqn = fqn;
    }

    public float[] value() {
        try {
            if (this.docValues != null && this.docValues.advanceExact(this.doc)) {
                BytesRef bytesRef = this.docValues.binaryValue();
                float[] values = new float[bytesRef.length / 4];
                ByteBuffer buffer = ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                buffer.asFloatBuffer().get(values);
                return values;
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        this.docValues = context.reader().getBinaryDocValues(this.fqn);
    }

    @Override
    public void setNextDocId(int doc) {
        this.doc = doc;
    }
}

