/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.index.fieldvisitor.IDVisitor;
import org.elasticsearch.index.mapper.Uid;

public abstract class IdCollectorExpression
extends LuceneCollectorExpression<String> {
    public static final Version STORED_AS_BINARY_VERSION = Version.V_6_0_0;
    protected int docId;

    public static IdCollectorExpression forVersion(Version version) {
        if (version.before(STORED_AS_BINARY_VERSION)) {
            return new StoredIdCollectorExpression();
        }
        return new BinaryIdCollectorExpression();
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    private static class StoredIdCollectorExpression
    extends IdCollectorExpression {
        private final IDVisitor visitor = new IDVisitor(SysColumns.ID.COLUMN.name());
        private ReaderContext context;

        private StoredIdCollectorExpression() {
        }

        public String value() {
            try {
                this.visitor.setCanStop(false);
                this.context.visitDocument(this.docId, this.visitor);
                return this.visitor.getId();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void setNextReader(ReaderContext context) throws IOException {
            this.context = context;
        }
    }

    private static class BinaryIdCollectorExpression
    extends IdCollectorExpression {
        private BinaryDocValues values;

        private BinaryIdCollectorExpression() {
        }

        public String value() {
            try {
                if (this.values.advanceExact(this.docId)) {
                    BytesRef bytes = this.values.binaryValue();
                    return Uid.decodeId(bytes.bytes, bytes.offset, bytes.length);
                }
                throw new IllegalStateException("No binary id for document " + this.docId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void setNextReader(ReaderContext context) throws IOException {
            this.values = DocValues.getBinary((LeafReader)context.reader(), (String)"_id");
        }
    }
}

