/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.UnhandledServerException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.doc.lucene.BitStringColumnReference;
import io.crate.expression.reference.doc.lucene.BooleanColumnReference;
import io.crate.expression.reference.doc.lucene.ByteColumnReference;
import io.crate.expression.reference.doc.lucene.DocCollectorExpression;
import io.crate.expression.reference.doc.lucene.DocIdCollectorExpression;
import io.crate.expression.reference.doc.lucene.DoubleColumnReference;
import io.crate.expression.reference.doc.lucene.FetchIdCollectorExpression;
import io.crate.expression.reference.doc.lucene.FloatColumnReference;
import io.crate.expression.reference.doc.lucene.FloatVectorColumnReference;
import io.crate.expression.reference.doc.lucene.GeoPointColumnReference;
import io.crate.expression.reference.doc.lucene.IdCollectorExpression;
import io.crate.expression.reference.doc.lucene.IntegerColumnReference;
import io.crate.expression.reference.doc.lucene.IpColumnReference;
import io.crate.expression.reference.doc.lucene.LongColumnReference;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.PrimaryTermCollectorExpression;
import io.crate.expression.reference.doc.lucene.RawCollectorExpression;
import io.crate.expression.reference.doc.lucene.ScoreCollectorExpression;
import io.crate.expression.reference.doc.lucene.SeqNoCollectorExpression;
import io.crate.expression.reference.doc.lucene.ShortColumnReference;
import io.crate.expression.reference.doc.lucene.StringColumnReference;
import io.crate.expression.reference.doc.lucene.VersionCollectorExpression;
import io.crate.expression.symbol.VoidReference;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Reference;
import io.crate.types.BitStringType;
import io.crate.types.DataType;
import io.crate.types.NumericStorage;
import io.crate.types.NumericType;
import io.crate.types.StringType;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.Version;

public class LuceneReferenceResolver
implements ReferenceResolver<LuceneCollectorExpression<?>> {
    private final List<Reference> partitionColumns;
    private final List<String> partitionValues;
    private final Predicate<Reference> isParentRefIgnored;
    private final Predicate<ColumnIdent> isSingletonPrimaryKey;
    private final Version shardVersion;

    public LuceneReferenceResolver(List<String> partitionValues, List<Reference> partitionColumns, List<ColumnIdent> primaryKey, Version shardVersion, Predicate<Reference> isParentRefIgnored) {
        this.partitionValues = partitionValues;
        this.partitionColumns = partitionColumns;
        this.isParentRefIgnored = isParentRefIgnored;
        this.shardVersion = shardVersion;
        this.isSingletonPrimaryKey = primaryKey.size() == 1 ? c -> ((ColumnIdent)primaryKey.getFirst()).equals(c) : columnIdent -> false;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @Override
    public LuceneCollectorExpression<?> getImplementation(Reference ref) {
        ColumnIdent column = ref.column();
        if (ref.valueType() instanceof StringType && this.isSingletonPrimaryKey.test(column)) {
            return IdCollectorExpression.forVersion(this.shardVersion);
        }
        switch (column.name()) {
            case "_raw": {
                if (column.isRoot()) {
                    return new RawCollectorExpression();
                }
                throw new UnsupportedFeatureException("_raw expression does not support subscripts: " + String.valueOf(column));
            }
            case "_uid": 
            case "_id": {
                return IdCollectorExpression.forVersion(this.shardVersion);
            }
            case "_fetchid": {
                return new FetchIdCollectorExpression();
            }
            case "_docid": {
                return new DocIdCollectorExpression();
            }
            case "_score": {
                return new ScoreCollectorExpression();
            }
            case "_version": {
                return new VersionCollectorExpression();
            }
            case "_seq_no": {
                return new SeqNoCollectorExpression();
            }
            case "_primary_term": {
                return new PrimaryTermCollectorExpression();
            }
            case "_doc": {
                return DocCollectorExpression.create(ref, this.isParentRefIgnored);
            }
        }
        int partitionPos = Reference.indexOf(this.partitionColumns, column);
        if (partitionPos >= 0) {
            return new LiteralValueExpression(ref.valueType().implicitCast(this.partitionValues.get(partitionPos)));
        }
        return LuceneReferenceResolver.typeSpecializedExpression(ref, this.isParentRefIgnored);
    }

    public static LuceneCollectorExpression<?> typeSpecializedExpression(Reference ref, Predicate<Reference> isParentRefIgnored) {
        String fqn = ref.storageIdent();
        if (ref instanceof VoidReference) {
            return new LiteralValueExpression(null);
        }
        if (!ref.hasDocValues()) {
            return DocCollectorExpression.create(DocReferences.toDocLookup(ref), isParentRefIgnored);
        }
        DataType<?> valueType = ref.valueType();
        return switch (valueType.id()) {
            case 25 -> new BitStringColumnReference(fqn, ((BitStringType)valueType).length());
            case 2 -> new ByteColumnReference(fqn);
            case 8 -> new ShortColumnReference(fqn);
            case 5 -> new IpColumnReference(fqn);
            case 4, 27 -> new StringColumnReference(fqn);
            case 6 -> new DoubleColumnReference(fqn);
            case 3 -> new BooleanColumnReference(fqn);
            case 7 -> new FloatColumnReference(fqn);
            case 10, 11, 15 -> new LongColumnReference(fqn);
            case 9 -> new IntegerColumnReference(fqn);
            case 13 -> new GeoPointColumnReference(fqn);
            case 100 -> DocCollectorExpression.create(DocReferences.toDocLookup(ref), isParentRefIgnored);
            case 28 -> new FloatVectorColumnReference(fqn);
            case 22 -> NumericStorage.getCollectorExpression(fqn, (NumericType)valueType);
            default -> throw new UnhandledServerException("Unsupported type: " + valueType.getName());
        };
    }

    static class LiteralValueExpression
    extends LuceneCollectorExpression<Object> {
        private final Object value;

        public LiteralValueExpression(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }
    }
}

