/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.ArrayViaDocValuesUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;

public abstract class NumericColumnReference<T>
extends LuceneCollectorExpression<T> {
    private final String luceneField;
    private SortedNumericDocValues docValues;
    private int docId;

    protected NumericColumnReference(String luceneField) {
        this.luceneField = luceneField;
    }

    protected abstract T convert(long var1);

    public T value() {
        try {
            if (!this.docValues.advanceExact(this.docId)) {
                return null;
            }
            if (this.docValues.docValueCount() > 1) {
                throw new ArrayViaDocValuesUnsupportedException(this.luceneField);
            }
            return this.convert(this.docValues.nextValue());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int doc) {
        this.docId = doc;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.luceneField);
    }
}

