/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.doc.SysColumns;
import io.crate.server.xcontent.XContentHelper;
import io.crate.sql.tree.BitString;
import io.crate.types.ArrayType;
import io.crate.types.BitStringType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FloatVectorType;
import io.crate.types.GeoPointType;
import io.crate.types.GeoShapeType;
import io.crate.types.ObjectType;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.Nullable;

public final class SourceParser {
    public static final String UNKNOWN_COLUMN_PREFIX = "_u_";
    private static final Logger LOGGER = LogManager.getLogger(SourceParser.class);
    private final Map<String, Object> requiredColumns = new HashMap<String, Object>();
    private final UnaryOperator<String> lookupNameBySourceKey;
    private final boolean strictMode;

    public SourceParser(UnaryOperator<String> lookupNameBySourceKey, boolean strictMode) {
        this.lookupNameBySourceKey = lookupNameBySourceKey;
        this.strictMode = strictMode;
    }

    public void register(ColumnIdent docColumn, DataType<?> type) {
        assert (docColumn.name().equals(SysColumns.DOC.name()) && docColumn.path().size() > 0) : "All columns registered for sourceParser must start with _doc";
        List<String> path = docColumn.path();
        if (path.size() == 1) {
            this.requiredColumns.put(docColumn.path().get(0), type);
        } else {
            HashMap columns = this.requiredColumns;
            for (int i = 0; i < path.size(); ++i) {
                String part = path.get(i);
                if (i + 1 == path.size()) {
                    columns.put(part, type);
                    continue;
                }
                Object object = columns.get(part);
                if (object instanceof Map) {
                    HashMap map;
                    columns = map = (HashMap)object;
                    continue;
                }
                if (object instanceof DataType) break;
                HashMap children = new HashMap();
                columns.put(part, (DataType<?>)((Object)children));
                columns = children;
            }
        }
    }

    public Map<String, Object> parse(BytesReference bytes) {
        return this.parse(bytes, false);
    }

    public Map<String, Object> parse(BytesReference bytes, boolean includeUnknownCols) {
        return this.parse(bytes, this.requiredColumns, includeUnknownCols);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> parse(BytesReference bytes, Map<String, Object> requiredColumns, boolean includeUnknownCols) {
        try (InputStream inputStream = XContentHelper.getUncompressedInputStream(bytes);){
            Map<String, Object> map;
            block15: {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, inputStream);
                try {
                    XContentParser.Token token = parser.currentToken();
                    if (token == null) {
                        parser.nextToken();
                    }
                    map = this.parseObject(parser, requiredColumns, includeUnknownCols);
                    if (parser == null) break block15;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Object parseArray(XContentParser parser, @Nullable DataType<?> type, @Nullable Map<String, Object> requiredColumns) throws IOException {
        if (type instanceof GeoPointType || type instanceof FloatVectorType) {
            return type.implicitCast(parser.list());
        }
        ArrayList<Object> values = new ArrayList<Object>();
        XContentParser.Token token = parser.nextToken();
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).innerType();
        }
        while (token != null && token != XContentParser.Token.END_ARRAY) {
            values.add(this.parseValue(parser, type, requiredColumns, false));
            token = parser.nextToken();
        }
        return values;
    }

    private Map<String, Object> parseObject(XContentParser parser, @Nullable Map<String, Object> requiredColumns, boolean includeUnknown) throws IOException {
        boolean parseAllFields = false;
        if (requiredColumns == null || requiredColumns.isEmpty()) {
            parseAllFields = true;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        XContentParser.Token token = parser.nextToken();
        while (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = (String)this.lookupNameBySourceKey.apply(parser.currentName());
            boolean dropped = fieldName == null;
            token = parser.nextToken();
            if (dropped) {
                parser.skipChildren();
            } else {
                Map<String, DataType<?>> required;
                Map<String, DataType<?>> map = required = requiredColumns == null ? null : requiredColumns.get(fieldName);
                if (!parseAllFields && required == null && !includeUnknown) {
                    parser.skipChildren();
                } else if (!(token != XContentParser.Token.START_ARRAY || !(required instanceof DataType) || required instanceof ArrayType || required instanceof GeoPointType || required instanceof GeoShapeType || required instanceof FloatVectorType || required instanceof UndefinedType)) {
                    parser.skipChildren();
                    values.put(fieldName, null);
                } else if (token == XContentParser.Token.VALUE_NULL) {
                    values.put(fieldName, null);
                } else {
                    boolean currentTreeIncludeUnknown = false;
                    DataType type = null;
                    if (required instanceof DataType) {
                        DataType dataType;
                        type = dataType = (DataType)((Object)required);
                        required = null;
                        DataType<?> dataType2 = ArrayType.unnest(dataType);
                        if (dataType2 instanceof ObjectType) {
                            ObjectType objectType = (ObjectType)dataType2;
                            required = objectType.innerTypes();
                            currentTreeIncludeUnknown = true;
                        }
                    }
                    Object value = null;
                    try {
                        value = this.parseValue(parser, type, (Map<String, Object>)required, currentTreeIncludeUnknown);
                    }
                    catch (Exception e) {
                        if (this.strictMode) {
                            throw e;
                        }
                        LOGGER.debug("Failed to parse value for column '" + fieldName + "', using NULL value instead", (Throwable)e);
                    }
                    values.put(fieldName, value);
                }
            }
            token = parser.nextToken();
        }
        return values;
    }

    private Object parseValue(XContentParser parser, @Nullable DataType<?> type, @Nullable Map<String, Object> requiredColumns, boolean includeUnknown) throws IOException {
        return switch (parser.currentToken()) {
            case XContentParser.Token.VALUE_NULL -> null;
            case XContentParser.Token.START_ARRAY -> this.parseArray(parser, type, requiredColumns);
            case XContentParser.Token.START_OBJECT -> this.parseObject(parser, requiredColumns, includeUnknown);
            case XContentParser.Token.VALUE_STRING -> {
                if (SourceParser.isUndefined(type)) {
                    yield parser.text();
                }
                yield SourceParser.parseByType(parser, type);
            }
            case XContentParser.Token.VALUE_NUMBER -> {
                if (SourceParser.isUndefined(type)) {
                    yield SourceParser.numberValue(parser.numberValue());
                }
                yield SourceParser.parseByType(parser, type);
            }
            case XContentParser.Token.VALUE_BOOLEAN -> {
                if (SourceParser.isUndefined(type)) {
                    yield parser.booleanValue();
                }
                yield SourceParser.parseByType(parser, type);
            }
            case XContentParser.Token.VALUE_EMBEDDED_OBJECT -> {
                if (SourceParser.isUndefined(type)) {
                    yield parser.binaryValue();
                }
                yield SourceParser.parseByType(parser, type);
            }
            default -> throw new UnsupportedOperationException("Unsupported token encountered, expected a value, got " + String.valueOf(parser.currentToken()));
        };
    }

    private static Number numberValue(Number number) {
        if (number instanceof BigInteger) {
            BigInteger bigInt = (BigInteger)number;
            return new BigDecimal(bigInt);
        }
        return number;
    }

    private static boolean isUndefined(@Nullable DataType<?> type) {
        return type == null || type.id() == DataTypes.UNDEFINED.id();
    }

    private static Object parseByType(XContentParser parser, DataType<?> type) throws IOException {
        assert (type != null) : "Type must no be null when parsing data type aware";
        DataType<?> elementType = ArrayType.unnest(type);
        return switch (elementType.id()) {
            case 3 -> Boolean.valueOf(parser.booleanValue());
            case 2 -> Byte.valueOf((byte)parser.intValue());
            case 8 -> Short.valueOf(parser.shortValue(true));
            case 9 -> Integer.valueOf(parser.intValue());
            case 10 -> Long.valueOf(parser.longValue());
            case 11 -> Long.valueOf(parser.longValue());
            case 15 -> Long.valueOf(parser.longValue());
            case 7 -> Float.valueOf(parser.floatValue());
            case 6 -> Double.valueOf(parser.doubleValue());
            case 25 -> new BitString(BitSet.valueOf(parser.binaryValue()), ((BitStringType)elementType).length());
            case 22 -> elementType.sanitizeValue(parser.text());
            default -> parser.text();
        };
    }
}

