/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.file;

import io.crate.execution.engine.collect.files.FileReadingIterator;
import io.crate.metadata.ColumnIdent;
import io.crate.server.xcontent.ParsedXContent;
import io.crate.server.xcontent.XContentHelper;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.Nullable;

public class LineContext {
    private final FileReadingIterator.LineCursor cursor;
    private byte[] rawSource;
    private LinkedHashMap<String, Object> parsedSource;
    private String currentParsingFailure;

    public LineContext(FileReadingIterator.LineCursor cursor) {
        this.cursor = cursor;
    }

    @Nullable
    String sourceAsString() {
        if (this.rawSource != null) {
            char[] chars = new char[this.rawSource.length];
            int len = UnicodeUtil.UTF8toUTF16((byte[])this.rawSource, (int)0, (int)this.rawSource.length, (char[])chars);
            return new String(chars, 0, len);
        }
        return null;
    }

    @Nullable
    LinkedHashMap<String, Object> sourceAsMap() {
        if (this.parsedSource == null && this.rawSource != null) {
            try {
                ParsedXContent parsedXContent = XContentHelper.convertToMap(new BytesArray(this.rawSource), true, XContentType.JSON);
                this.parsedSource = (LinkedHashMap)parsedXContent.map();
            }
            catch (ElasticsearchParseException | NotXContentException e) {
                throw new RuntimeException("JSON parser error: " + e.getMessage(), e);
            }
        }
        return this.parsedSource;
    }

    public Object get(ColumnIdent columnIdent) {
        LinkedHashMap<String, Object> parentMap = this.sourceAsMap();
        if (parentMap == null) {
            return null;
        }
        return ColumnIdent.get(parentMap, columnIdent);
    }

    public void rawSource(byte[] bytes) {
        this.rawSource = bytes;
        this.parsedSource = null;
    }

    String currentUri() {
        return this.cursor.uri().toString();
    }

    public void setCurrentParsingFailure(String failureMessage) {
        this.currentParsingFailure = failureMessage;
    }

    @Nullable
    String getCurrentUriFailure() {
        IOException failure = this.cursor.failure();
        return failure == null ? null : failure.getMessage();
    }

    @Nullable
    String getCurrentParsingFailure() {
        return this.currentParsingFailure;
    }

    public long getCurrentLineNumber() {
        return this.cursor.lineNumber();
    }

    public void resetCurrentParsingFailure() {
        this.currentParsingFailure = null;
    }
}

