/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.DiskWatermarkNodesSysCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeService;

@Singleton
public class HighDiskWatermarkNodesSysCheck
extends DiskWatermarkNodesSysCheck {
    static final int ID = 5;
    private static final String DESCRIPTION = "The high disk watermark is exceeded on the node. The cluster will attempt to relocate shards to another node. Please check the node disk usage.";

    @Inject
    public HighDiskWatermarkNodesSysCheck(ClusterService clusterService, Settings settings, NodeService nodeService) {
        super(5, DESCRIPTION, SysCheck.Severity.HIGH, clusterService, nodeService.getMonitorService().fsService(), settings);
    }

    @Override
    protected boolean isValid(long free, long total) {
        return free >= this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() && !(HighDiskWatermarkNodesSysCheck.getFreeDiskAsPercentage(free, total) < this.diskThresholdSettings.getFreeDiskThresholdHigh());
    }
}

