/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.ShardLimitValidator;

@Singleton
public class MaxShardsPerNodeSysCheck
extends AbstractSysNodeCheck {
    static final int ID = 8;
    private static final String DESCRIPTION = "The amount of shards on the node reached 90 % of the limit of the cluster setting `cluster.max_shards_per_node`. Creating new tables or partitions which would push the number of shards beyond 100 % of the limit will be rejected.";
    private static final double PERCENTAGE_MAX_SHARDS_PER_NODE_THRESHOLD = 0.9;
    private final ClusterService clusterService;

    @Inject
    public MaxShardsPerNodeSysCheck(ClusterService clusterService) {
        super(8, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.clusterService = clusterService;
    }

    @Override
    public boolean isValid() {
        double maxShardLimitPerNode = this.clusterService.getClusterSettings().get(ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE).doubleValue();
        ClusterState state = this.clusterService.state();
        String localNodeId = state.nodes().getLocalNodeId();
        int numberOfShardsOnLocalNode = 0;
        for (IndexRoutingTable indexRoutingTable : state.routingTable()) {
            Index index = indexRoutingTable.getIndex();
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (!localNodeId.equals(shardRouting.currentNodeId())) continue;
                    ++numberOfShardsOnLocalNode;
                }
            }
        }
        return (double)numberOfShardsOnLocalNode / maxShardLimitPerNode < 0.9;
    }
}

