/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import io.crate.blob.v2.BlobShard;
import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.jetbrains.annotations.Nullable;

public class ShardRowContext {
    private final RelationName relationName;
    private final IndexShard indexShard;
    @Nullable
    private final BlobShard blobShard;
    private final ClusterService clusterService;
    private final Supplier<Long> sizeSupplier;
    private final String partitionIdent;
    private final List<String> partitionValues;
    private final int id;
    private final String path;
    @Nullable
    private final String blobPath;
    private final boolean orphanedPartition;

    public ShardRowContext(IndexShard indexShard, ClusterService clusterService) {
        this(indexShard, null, clusterService, () -> {
            try {
                StoreStats storeStats = indexShard.storeStats();
                return storeStats.sizeInBytes();
            }
            catch (AlreadyClosedException e) {
                return 0L;
            }
        });
    }

    public ShardRowContext(BlobShard blobShard, ClusterService clusterService) {
        this(blobShard.indexShard(), blobShard, clusterService, blobShard::getTotalSize);
    }

    private ShardRowContext(IndexShard indexShard, @Nullable BlobShard blobShard, ClusterService clusterService, Supplier<Long> sizeSupplier) {
        this.indexShard = indexShard;
        this.blobShard = blobShard;
        this.clusterService = clusterService;
        this.sizeSupplier = sizeSupplier;
        ShardId shardId = indexShard.shardId();
        this.id = shardId.id();
        Metadata metadata = clusterService.state().metadata();
        IndexMetadata index = metadata.index(shardId.getIndexUUID());
        if (index == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "IndexMetadata for shard %s does not exist in the cluster state", shardId));
        }
        @Nullable RelationMetadata relation = metadata.getRelation(shardId.getIndexUUID());
        if (relation == null) {
            this.orphanedPartition = true;
            this.relationName = IndexName.decode(shardId.getIndexName()).toRelationName();
        } else {
            this.orphanedPartition = false;
            this.relationName = relation.name();
        }
        this.partitionValues = index.partitionValues();
        this.partitionIdent = this.partitionValues.isEmpty() ? "" : PartitionName.encodeIdent(index.partitionValues());
        this.path = indexShard.shardPath().getDataPath().toString();
        this.blobPath = blobShard == null ? null : blobShard.blobContainer().getBaseDirectory().toString();
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    public Long size() {
        return this.sizeSupplier.get();
    }

    @Nullable
    public String partitionIdent() {
        return this.partitionIdent;
    }

    public String partitionUUID() {
        return this.indexShard.shardId().getIndex().getUUID();
    }

    public int id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    @Nullable
    public String blobPath() {
        return this.blobPath;
    }

    @Nullable
    public Long numDocs() {
        if (this.blobShard == null) {
            try {
                return this.indexShard.numDocs();
            }
            catch (IllegalIndexShardStateException e) {
                return null;
            }
        }
        return this.blobShard.getBlobsCount();
    }

    public boolean isOrphanedPartition() {
        return this.orphanedPartition;
    }

    public boolean isClosed() {
        return this.indexShard.isClosed();
    }

    @Nullable
    public String minLuceneVersion() {
        long numDocs;
        try {
            numDocs = this.indexShard.numDocs();
        }
        catch (IllegalIndexShardStateException e) {
            return null;
        }
        if (numDocs == 0L) {
            return Version.CURRENT.luceneVersion.toString();
        }
        try {
            return this.indexShard.minimumCompatibleVersion().toString();
        }
        catch (AlreadyClosedException e) {
            return null;
        }
    }

    public long maxSeqNo() {
        try {
            SeqNoStats stats = this.indexShard.seqNoStats();
            return stats.getMaxSeqNo();
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    public long localSeqNoCheckpoint() {
        try {
            SeqNoStats stats = this.indexShard.seqNoStats();
            return stats.getLocalCheckpoint();
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    public long globalSeqNoCheckpoint() {
        try {
            SeqNoStats stats = this.indexShard.seqNoStats();
            return stats.getGlobalCheckpoint();
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Long translogSizeInBytes() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Long.valueOf(stats.getTranslogSizeInBytes());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Long translogUncommittedSizeInBytes() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Long.valueOf(stats.getUncommittedSizeInBytes());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Integer translogEstimatedNumberOfOperations() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Integer.valueOf(stats.estimatedNumberOfOperations());
        }
        catch (AlreadyClosedException e) {
            return 0;
        }
    }

    @Nullable
    public Integer translogUncommittedOperations() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Integer.valueOf(stats.getUncommittedOperations());
        }
        catch (AlreadyClosedException e) {
            return 0;
        }
    }

    @Nullable
    public String recoveryStage() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : recoveryState.getStage().name();
    }

    @Nullable
    public String recoveryType() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : recoveryState.getRecoverySource().getType().name();
    }

    @Nullable
    public Long recoveryTotalTime() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getTimer().time());
    }

    @Nullable
    public Long recoverySizeUsed() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getIndex().totalBytes());
    }

    @Nullable
    public Long recoverySizeReused() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getIndex().reusedBytes());
    }

    @Nullable
    public Long recoverySizeRecoveredBytes() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getIndex().recoveredBytes());
    }

    @Nullable
    public Float recoverySizeRecoveredBytesPercent() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Float.valueOf(recoveryState.getIndex().recoveredBytesPercent());
    }

    @Nullable
    public Integer recoveryFilesUsed() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Integer.valueOf(recoveryState.getIndex().totalFileCount());
    }

    @Nullable
    public Integer recoveryFilesReused() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Integer.valueOf(recoveryState.getIndex().reusedFileCount());
    }

    @Nullable
    public Integer recoveryFilesRecovered() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Integer.valueOf(recoveryState.getIndex().recoveredFileCount());
    }

    @Nullable
    public Float recoveryFilesPercent() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Float.valueOf(recoveryState.getIndex().recoveredFilesPercent());
    }

    public Long retentionLeasesPrimaryTerm() {
        try {
            return this.indexShard.getRetentionLeaseStats().leases().primaryTerm();
        }
        catch (AlreadyClosedException | IndexShardClosedException e) {
            return null;
        }
    }

    public Long retentionLeasesVersion() {
        try {
            return this.indexShard.getRetentionLeaseStats().leases().version();
        }
        catch (AlreadyClosedException | IndexShardClosedException e) {
            return null;
        }
    }

    public Collection<RetentionLease> retentionLeases() {
        try {
            return this.indexShard.getRetentionLeaseStats().leases().leases();
        }
        catch (AlreadyClosedException | IndexShardClosedException e) {
            return List.of();
        }
    }

    public long flushCount() {
        return this.indexShard.getFlushMetric().count();
    }

    public long flushTotalTimeNs() {
        return this.indexShard.getFlushMetric().sum();
    }

    public long flushPeriodicCount() {
        return this.indexShard.periodicFlushCount();
    }
}

