/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import io.crate.exceptions.RelationUnknown;
import io.crate.expression.reference.sys.shard.ShardSegment;
import io.crate.metadata.PartitionName;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;

@Singleton
public class ShardSegments
implements Iterable<ShardSegment> {
    private final IndicesService indicesService;
    private final ClusterService clusterService;

    @Inject
    public ShardSegments(IndicesService indicesService, ClusterService clusterService) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
    }

    @Override
    public Iterator<ShardSegment> iterator() {
        return StreamSupport.stream(this.indicesService.spliterator(), false).flatMap(indexService -> StreamSupport.stream(indexService.spliterator(), false)).filter(x -> !x.routingEntry().unassigned()).flatMap(this::buildShardSegment).iterator();
    }

    private Stream<ShardSegment> buildShardSegment(IndexShard indexShard) {
        try {
            List<Segment> segments = indexShard.segments();
            ShardId shardId = indexShard.shardId();
            PartitionName partitionName = this.clusterService.state().metadata().getPartitionName(shardId.getIndexUUID());
            return segments.stream().map(sgmt -> new ShardSegment(shardId.id(), partitionName, (Segment)sgmt, indexShard.routingEntry().primary()));
        }
        catch (RelationUnknown | AlreadyClosedException | IndexNotFoundException ignored) {
            return Stream.empty();
        }
    }
}

