/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import io.crate.common.collections.Lists;
import io.crate.metadata.PartitionName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.Nullable;

public class SysAllocation {
    private final ShardId shardId;
    private final ShardRoutingState currentState;
    private final PartitionName partitionName;
    private final Supplier<ShardAllocationDecision> computeDecision;
    private final String nodeId;
    private final boolean primary;
    private ShardAllocationDecision decision;
    private List<SysAllocationNodeDecision> decisions;

    public SysAllocation(ShardId shardId, ShardRoutingState routingState, Supplier<ShardAllocationDecision> computeDecision, @Nullable String nodeId, boolean isPrimary, PartitionName partitionName) {
        this.shardId = shardId;
        this.currentState = routingState;
        this.partitionName = partitionName;
        this.computeDecision = computeDecision;
        this.nodeId = nodeId;
        this.primary = isPrimary;
    }

    public String tableSchema() {
        return this.partitionName.relationName().schema();
    }

    public String tableName() {
        return this.partitionName.relationName().name();
    }

    @Nullable
    public String partitionIdent() {
        return this.partitionName.ident();
    }

    public int shardId() {
        return this.shardId.id();
    }

    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    public boolean primary() {
        return this.primary;
    }

    public ShardRoutingState currentState() {
        return this.currentState;
    }

    public String explanation() {
        if (this.decision == null) {
            this.decision = this.computeDecision.get();
        }
        if (this.decision.getMoveDecision().isDecisionTaken()) {
            return this.decision.getMoveDecision().getExplanation();
        }
        if (this.decision.getAllocateDecision().isDecisionTaken()) {
            return this.decision.getAllocateDecision().getExplanation();
        }
        return null;
    }

    @Nullable
    public List<SysAllocationNodeDecision> decisions() {
        if (this.decision == null) {
            this.decision = this.computeDecision.get();
            this.decisions = this.nodeDecisions();
        }
        return this.decisions.isEmpty() ? null : this.decisions;
    }

    private List<SysAllocationNodeDecision> nodeDecisions() {
        assert (this.decision != null) : "decision must be initialized to generate nodeDecisions";
        if (this.decision.getMoveDecision().isDecisionTaken()) {
            return Lists.map(this.decision.getMoveDecision().getNodeDecisions(), SysAllocationNodeDecision::fromNodeAllocationResult);
        }
        if (this.decision.getAllocateDecision().isDecisionTaken()) {
            return Lists.map(this.decision.getAllocateDecision().getNodeDecisions(), SysAllocationNodeDecision::fromNodeAllocationResult);
        }
        return List.of();
    }

    public String fqn() {
        return this.partitionName.relationName().fqn();
    }

    public static class SysAllocationNodeDecision {
        final String nodeId;
        final String nodeName;
        final List<String> explanations;

        private SysAllocationNodeDecision(String nodeId, String nodeName, @Nullable List<String> explanations) {
            this.nodeId = nodeId;
            this.nodeName = nodeName;
            this.explanations = explanations;
        }

        static SysAllocationNodeDecision fromNodeAllocationResult(NodeAllocationResult allocationResult) {
            return new SysAllocationNodeDecision(allocationResult.getNode().getId(), allocationResult.getNode().getName(), SysAllocationNodeDecision.getExplanations(allocationResult));
        }

        @Nullable
        private static List<String> getExplanations(NodeAllocationResult allocationResult) {
            if (allocationResult.getCanAllocateDecision() != null && !allocationResult.getCanAllocateDecision().getDecisions().isEmpty()) {
                ArrayList<String> explanations = new ArrayList<String>();
                allocationResult.getCanAllocateDecision().getDecisions().forEach(d -> {
                    if (d.getExplanation() != null) {
                        explanations.add(d.getExplanation());
                    }
                });
                return explanations;
            }
            return null;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String nodeName() {
            return this.nodeName;
        }

        @Nullable
        public List<String> explanations() {
            return this.explanations;
        }
    }
}

