/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.snapshot;

import io.crate.common.collections.Lists;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;

public record SysSnapshot(String uuid, String name, String repository, List<RelationName> tables, List<PartitionName> partitions, List<String> concreteIndices, Long started, Long finished, String version, String state, List<String> failures, String reason, int totalShards, Boolean includeGlobalState) {
    public static SysSnapshot of(Metadata metadata, SnapshotsInProgress.Entry inProgressEntry) {
        Snapshot snapshot = inProgressEntry.snapshot();
        SnapshotId snapshotId = snapshot.getSnapshotId();
        ArrayList<PartitionName> partitions = new ArrayList<PartitionName>();
        ArrayList<String> indexNames = new ArrayList<String>();
        for (IndexId indexId : inProgressEntry.indices()) {
            String indexName = indexId.getName();
            IndexMetadata indexMetadata = metadata.getIndexByName(indexName);
            assert (indexMetadata != null) : "There must be indexMetadata for any index in SnapshotsInProgress.Entry";
            RelationMetadata relation = metadata.getRelation(indexMetadata.getIndexUUID());
            assert (relation != null) : "If an index is in a SnapshotsInProgress.Entry the relationMetadata for it must exist";
            if (!indexMetadata.partitionValues().isEmpty()) {
                partitions.add(new PartitionName(relation.name(), indexMetadata.partitionValues()));
            }
            indexNames.add(indexName);
        }
        return new SysSnapshot(snapshotId.getUUID(), snapshotId.getName(), snapshot.getRepository(), inProgressEntry.relationNames(), partitions, indexNames, inProgressEntry.startTime(), 0L, Version.CURRENT.toString(), SnapshotState.IN_PROGRESS.name(), List.of(), inProgressEntry.failure(), inProgressEntry.shards().size(), inProgressEntry.includeGlobalState());
    }

    public static SysSnapshot of(Metadata snapshotMetadata, String repoName, SnapshotInfo info) {
        SnapshotId snapshotId = info.snapshotId();
        Version version = info.version();
        List<String> indexNames = info.indexNames();
        ArrayList<PartitionName> partitions = new ArrayList<PartitionName>();
        LinkedHashSet<RelationName> relations = new LinkedHashSet<RelationName>();
        relations.addAll(Lists.mapLazy(snapshotMetadata.relations(RelationMetadata.Table.class), RelationMetadata::name));
        for (String indexName : indexNames) {
            RelationMetadata relation;
            IndexMetadata indexMetadata = snapshotMetadata.getIndexByName(indexName);
            RelationMetadata relationMetadata = relation = indexMetadata == null ? null : snapshotMetadata.getRelation(indexMetadata.getIndexUUID());
            if (relation == null) {
                IndexParts indexParts = IndexName.decode(indexName);
                if (indexParts.isPartitioned()) {
                    partitions.add(indexParts.toPartitionName());
                }
                relations.add(indexParts.toRelationName());
                continue;
            }
            relations.add(relation.name());
            if (indexMetadata.partitionValues().isEmpty()) continue;
            partitions.add(new PartitionName(relation.name(), indexMetadata.partitionValues()));
        }
        return new SysSnapshot(snapshotId.getUUID(), snapshotId.getName(), repoName, List.copyOf(relations), partitions, indexNames, info.startTime(), info.endTime(), version == null ? null : version.toString(), info.state().name(), Lists.map(info.shardFailures(), SnapshotShardFailure::toString), info.reason(), info.totalShards(), info.includeGlobalState());
    }

    public static SysSnapshot ofMissingInfo(String repoName, SnapshotId snapshotId) {
        return new SysSnapshot(snapshotId.getUUID(), snapshotId.getName(), repoName, List.of(), List.of(), List.of(), null, null, null, SnapshotState.FAILED.name(), List.of(), null, 0, null);
    }

    public List<String> tableNames() {
        return Lists.map(this.tables, RelationName::fqn);
    }
}

