/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.snapshot;

import io.crate.common.concurrent.CompletableFutures;
import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.reference.sys.snapshot.SysSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SysSnapshots {
    private static final Logger LOGGER = LogManager.getLogger(SysSnapshots.class);
    private final Supplier<Collection<Repository>> getRepositories;
    private final ClusterService clusterService;

    @Inject
    public SysSnapshots(RepositoriesService repositoriesService, ClusterService clusterService) {
        this(repositoriesService::getRepositoriesList, clusterService);
    }

    @VisibleForTesting
    SysSnapshots(Supplier<Collection<Repository>> getRepositories, ClusterService clusterService) {
        this.getRepositories = getRepositories;
        this.clusterService = clusterService;
    }

    public CompletableFuture<Iterable<SysSnapshot>> currentSnapshots() {
        ArrayList<CompletionStage> remoteSnapshots = new ArrayList<CompletionStage>();
        ClusterState state = this.clusterService.state();
        Metadata metadata = state.metadata();
        for (Repository repository : this.getRepositories.get()) {
            CompletionStage futureSnapshots = repository.getRepositoryData().thenCompose(repositoryData -> {
                Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
                ArrayList<CompletableFuture<SysSnapshot>> snapshots = new ArrayList<CompletableFuture<SysSnapshot>>(snapshotIds.size());
                for (SnapshotId snapshotId : snapshotIds) {
                    snapshots.add(SysSnapshots.createSysSnapshot(repository, snapshotId));
                }
                return CompletableFutures.allSuccessfulAsList(snapshots);
            });
            remoteSnapshots.add(futureSnapshots);
        }
        return CompletableFutures.allSuccessfulAsList(remoteSnapshots).thenApply(data -> {
            ArrayList<SysSnapshot> result = new ArrayList<SysSnapshot>();
            for (Collection datum : data) {
                result.addAll(datum);
            }
            for (SnapshotsInProgress.Entry inProgressEntry : state.custom("snapshots", SnapshotsInProgress.EMPTY).entries()) {
                result.add(SysSnapshot.of(metadata, inProgressEntry));
            }
            return result;
        });
    }

    private static CompletableFuture<SysSnapshot> createSysSnapshot(Repository repository, SnapshotId snapshotId) {
        String repoName = repository.getMetadata().name();
        return ((CompletableFuture)repository.getSnapshotGlobalMetadata(snapshotId).thenCombine(repository.getSnapshotInfo(snapshotId), (metadata, info) -> SysSnapshot.of(metadata, repoName, info))).exceptionally(t -> {
            Throwable err = SQLExceptions.unwrap(t);
            if (err instanceof SnapshotException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Couldn't retrieve snapshotId={} error={}", (Object)snapshotId, (Object)err);
                }
                return SysSnapshot.ofMissingInfo(repository.getMetadata().name(), snapshotId);
            }
            throw Exceptions.toRuntimeException((Throwable)err);
        });
    }
}

