/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.Collections;
import java.util.List;

public class ArrayOverlapFunction
extends Scalar<Boolean, List<Object>> {
    public static final String NAME = "array_overlap";
    public static final Signature SIGNATURE = Signature.builder("array_overlap", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("array(E)")).returnType(DataTypes.BOOLEAN.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, ArrayOverlapFunction::new);
    }

    ArrayOverlapFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<List<Object>> ... args) {
        List firstList = (List)args[0].value();
        List secondList = (List)args[1].value();
        if (firstList == null || secondList == null) {
            return null;
        }
        return !Collections.disjoint(firstList, secondList);
    }
}

