/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

public class ArrayPrependFunction
extends Scalar<List<Object>, Object> {
    public static final String NAME = "array_prepend";
    private final DataType<?> innerType;
    private final boolean calledByOperator;

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), ArrayPrependFunction::new);
    }

    ArrayPrependFunction(Signature signature, BoundSignature boundSignature) {
        this(signature, boundSignature, false);
    }

    ArrayPrependFunction(Signature signature, BoundSignature boundSignature, boolean calledByOperator) {
        super(signature, boundSignature);
        this.innerType = ((ArrayType)boundSignature.returnType()).innerType();
        this.calledByOperator = calledByOperator;
    }

    @Override
    public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        Object valueToAdd = args[0].value();
        List values = (List)args[1].value();
        if (valueToAdd != null || !this.calledByOperator) {
            resultList.add(this.innerType.sanitizeValue(valueToAdd));
        }
        if (values != null) {
            for (Object value : values) {
                resultList.add(this.innerType.sanitizeValue(value));
            }
        }
        return resultList;
    }
}

