/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

public class ArraySliceFunction
extends Scalar<List<Object>, Object> {
    public static final String NAME = "array_slice";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), ArraySliceFunction::new);
    }

    private ArraySliceFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), signature.getName().name());
    }

    @Override
    public List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object>[] args) {
        List listInput = (List)args[0].value();
        if (listInput == null || listInput.isEmpty()) {
            return List.of();
        }
        int from = 1;
        if (args.length >= 2) {
            from = ArraySliceFunction.intValueOrDefault(args[1], 1);
            ArraySliceFunction.ensureGtZero(from);
        }
        int to = listInput.size();
        if (args.length == 3) {
            to = Math.min(to, ArraySliceFunction.intValueOrDefault(args[2], listInput.size()));
        }
        ArraySliceFunction.ensureGtZero(to);
        return to >= from ? new ArrayList(listInput.subList(from - 1, to)) : List.of();
    }

    private static int intValueOrDefault(Input<Object> arg, int defaultValue) {
        Object value = arg.value();
        try {
            if (value != null) {
                return ((Number)value).intValue();
            }
            return defaultValue;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Array index must be in range 1 to 2147483647", e);
        }
    }

    private static void ensureGtZero(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Array index must be in range 1 to 2147483647");
        }
    }
}

