/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.expression.scalar.array.ArraySummationFunctions;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.LongType;
import java.util.List;
import java.util.function.Function;

public class ArraySumFunction<T extends Number, R extends Number>
extends Scalar<R, List<T>> {
    public static final String NAME = "array_sum";
    private final Function<List<T>, R> sum;

    private static <T, U> Signature signature(DataType<T> elementType, DataType<U> returnType) {
        return Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<T>(elementType).getTypeSignature()).returnType(returnType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build();
    }

    public static void register(Functions.Builder builder) {
        builder.add(ArraySumFunction.signature(DataTypes.NUMERIC, DataTypes.NUMERIC), (sig, boundSig) -> new ArraySumFunction((Signature)sig, (BoundSignature)boundSig, ArraySummationFunctions::sumBigDecimal));
        builder.add(ArraySumFunction.signature(DataTypes.DOUBLE, DataTypes.DOUBLE), (sig, boundSig) -> new ArraySumFunction((Signature)sig, (BoundSignature)boundSig, ArraySummationFunctions::sumDouble));
        builder.add(ArraySumFunction.signature(DataTypes.FLOAT, DataTypes.FLOAT), (sig, boundSig) -> new ArraySumFunction((Signature)sig, (BoundSignature)boundSig, ArraySummationFunctions::sumFloat));
        List<LongType> integralTypes = List.of(DataTypes.BYTE, DataTypes.SHORT, DataTypes.INTEGER, DataTypes.LONG);
        for (DataType dataType : integralTypes) {
            builder.add(ArraySumFunction.signature(dataType, DataTypes.LONG), (sig, boundSig) -> new ArraySumFunction((Signature)sig, (BoundSignature)boundSig, ArraySummationFunctions::sumNumber));
        }
    }

    private ArraySumFunction(Signature signature, BoundSignature boundSignature, Function<List<T>, R> sum) {
        super(signature, boundSignature);
        this.sum = sum;
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), signature.getName().name());
    }

    @Override
    @SafeVarargs
    public final R evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<T>> ... args) {
        List values = (List)args[0].value();
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (R)((Number)this.sum.apply(values));
    }
}

