/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.execution.dml.ArrayIndexer;
import io.crate.expression.operator.Operators;
import io.crate.expression.scalar.NumTermsPerDocQuery;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.IntPredicate;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.Nullable;

public class ArrayUpperFunction
extends Scalar<Integer, Object> {
    public static final String ARRAY_UPPER = "array_upper";
    public static final String ARRAY_LENGTH = "array_length";
    public static final int LOWER_BOUND = 1;
    public static final int UPPER_BOUND = Integer.MAX_VALUE;

    public static void register(Functions.Builder module) {
        for (String name : List.of(ARRAY_UPPER, ARRAY_LENGTH)) {
            module.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC).build(), ArrayUpperFunction::new);
        }
    }

    private ArrayUpperFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), signature.getName().name());
    }

    @Override
    public Integer evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        List values = (List)args[0].value();
        Object dimensionArg = args[1].value();
        if (values == null || values.isEmpty() || dimensionArg == null) {
            return null;
        }
        int dimension = (Integer)dimensionArg;
        if (dimension <= 0) {
            return null;
        }
        return ArrayUpperFunction.upperBound(values, dimension, 1);
    }

    static final Integer upperBound(@Nullable Object arrayOrItem, int requestedDimension, int currentDimension) {
        if (arrayOrItem instanceof List) {
            List dimensionArray = (List)arrayOrItem;
            if (currentDimension == requestedDimension) {
                return dimensionArray.size();
            }
            int max = Integer.MIN_VALUE;
            for (Object object : dimensionArray) {
                Integer upper = ArrayUpperFunction.upperBound(object, requestedDimension, currentDimension + 1);
                if (upper == null) continue;
                max = Math.max(max, upper);
            }
            return max == Integer.MIN_VALUE ? null : Integer.valueOf(max);
        }
        return null;
    }

    @Override
    public Query toQuery(Function parent, Function arrayLength, LuceneQueryBuilder.Context context) {
        String parentName = parent.name();
        if (!Operators.COMPARISON_OPERATORS.contains(parentName)) {
            return null;
        }
        List<Symbol> parentArgs = parent.arguments();
        Symbol cmpSymbol = parentArgs.get(1);
        if (!(cmpSymbol instanceof Input)) {
            return null;
        }
        Number cmpNumber = (Number)((Input)cmpSymbol).value();
        assert (cmpNumber != null) : "If the second argument to a cmp operator is a null literal it should normalize to null";
        List<Symbol> arrayLengthArgs = arrayLength.arguments();
        Symbol arraySymbol = arrayLengthArgs.get(0);
        if (!(arraySymbol instanceof Reference)) {
            return null;
        }
        Reference arrayRef = (Reference)arraySymbol;
        Symbol dimensionSymbol = arrayLengthArgs.get(1);
        if (!(dimensionSymbol instanceof Input)) {
            return null;
        }
        int dimension = ((Number)((Input)dimensionSymbol).value()).intValue();
        if (dimension <= 0 || dimension > ArrayType.dimensions(arrayRef.valueType())) {
            return new MatchNoDocsQuery("Dimension argument <= 0 or exceeding the dimension of the array cannot match");
        }
        if (dimension != 1) {
            return null;
        }
        int cmpVal = cmpNumber.intValue();
        if (context.tableInfo().versionCreated().onOrAfter(ArrayIndexer.ARRAY_LENGTH_FIELD_SUPPORTED_VERSION)) {
            return ArrayUpperFunction.toQueryUsingArrayLengthIndex(parentName, arrayRef, cmpVal, context.tableInfo()::getReference);
        }
        DataType innerType = ((ArrayType)arrayRef.valueType()).innerType();
        if (innerType instanceof ArrayType) {
            return null;
        }
        DataType<?> elementType = ArrayType.unnest(arrayRef.valueType());
        if (elementType.id() == 12 || elementType.equals(DataTypes.GEO_SHAPE)) {
            return null;
        }
        IntPredicate valueCountIsMatch = ArrayUpperFunction.predicateForFunction(parentName, cmpVal);
        switch (parentName) {
            case "op_=": {
                if (cmpVal == 0) {
                    return new MatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) = 0 can't match");
                }
                return ArrayUpperFunction.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_>": {
                return ArrayUpperFunction.docValueCountOrGeneric(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_>=": {
                if (cmpVal == 0) {
                    return ArrayUpperFunction.docValueCountOrGeneric(parent, context, arrayRef, ArrayUpperFunction.predicateForFunction("op_>=", 1));
                }
                return ArrayUpperFunction.docValueCountOrGeneric(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_<": {
                if (cmpVal == 0 || cmpVal == 1) {
                    return new MatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) < 0 or < 1 can't match");
                }
                return ArrayUpperFunction.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
            case "op_<=": {
                if (cmpVal == 0) {
                    return new MatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) <= 0 can't match");
                }
                return ArrayUpperFunction.genericAndDocValueCount(parent, context, arrayRef, valueCountIsMatch);
            }
        }
        throw new IllegalArgumentException("Illegal operator: " + parentName);
    }

    private static Query docValueCountOrGeneric(Function parent, LuceneQueryBuilder.Context context, Reference arrayRef, IntPredicate valueCountIsMatch) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.setMinimumNumberShouldMatch(1);
        return query.add((Query)NumTermsPerDocQuery.forRef(arrayRef, valueCountIsMatch), BooleanClause.Occur.SHOULD).add(LuceneQueryBuilder.genericFunctionFilter(parent, context), BooleanClause.Occur.SHOULD).build();
    }

    private static Query genericAndDocValueCount(Function parent, LuceneQueryBuilder.Context context, Reference arrayRef, IntPredicate valueCountIsMatch) {
        return new BooleanQuery.Builder().add((Query)NumTermsPerDocQuery.forRef(arrayRef, valueCountIsMatch), BooleanClause.Occur.MUST).add(LuceneQueryBuilder.genericFunctionFilter(parent, context), BooleanClause.Occur.FILTER).build();
    }

    private static IntPredicate predicateForFunction(String cmpFuncName, int cmpValue) {
        switch (cmpFuncName) {
            case "op_<": {
                return x -> x < cmpValue;
            }
            case "op_<=": {
                return x -> x <= cmpValue;
            }
            case "op_>": {
                return x -> x > cmpValue;
            }
            case "op_>=": {
                return x -> x >= cmpValue;
            }
            case "op_=": {
                return x -> x <= cmpValue;
            }
        }
        throw new IllegalArgumentException("Unknown comparison function: " + cmpFuncName);
    }

    private static Query toQueryUsingArrayLengthIndex(String operator, Reference arrayRef, int cmpVal, java.util.function.Function<ColumnIdent, Reference> getRef) {
        switch (operator) {
            case "op_=": {
                if (cmpVal == 0) {
                    return new MatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) = 0 can't match");
                }
                return ArrayIndexer.arrayLengthTermQuery(arrayRef, cmpVal, getRef);
            }
            case "op_>": {
                return ArrayIndexer.arrayLengthRangeQuery(arrayRef, cmpVal + 1, Integer.MAX_VALUE, getRef);
            }
            case "op_>=": {
                if (cmpVal == 0) {
                    return ArrayIndexer.arrayLengthRangeQuery(arrayRef, 1, Integer.MAX_VALUE, getRef);
                }
                return ArrayIndexer.arrayLengthRangeQuery(arrayRef, cmpVal, Integer.MAX_VALUE, getRef);
            }
            case "op_<": {
                if (cmpVal == 0 || cmpVal == 1) {
                    return new MatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) < 0 or < 1 can't match");
                }
                return ArrayIndexer.arrayLengthRangeQuery(arrayRef, 1, cmpVal - 1, getRef);
            }
            case "op_<=": {
                if (cmpVal == 0) {
                    return new MatchNoDocsQuery("array_length([], 1) is NULL, so array_length([], 1) <= 0 can't match");
                }
                return ArrayIndexer.arrayLengthRangeQuery(arrayRef, 1, cmpVal, getRef);
            }
        }
        throw new IllegalArgumentException("Illegal operator: " + operator);
    }
}

