/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.execution.dml.ArrayIndexer;
import io.crate.expression.scalar.NumTermsPerDocQuery;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.NumericType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

public class NumNullTermsPerDocQuery
extends NumTermsPerDocQuery {
    public static NumNullTermsPerDocQuery of(Reference ref, Function<ColumnIdent, Reference> getRef, IntPredicate matches) {
        if (!NumNullTermsPerDocQuery.hasArrayLengthIndexAndSortedNumericDocValues(ref.valueType(), ref.hasDocValues())) {
            return null;
        }
        return new NumNullTermsPerDocQuery(ref, getRef, matches);
    }

    private static boolean hasArrayLengthIndexAndSortedNumericDocValues(DataType<?> type, boolean hasDocValues) {
        if (ArrayType.dimensions(type) != 1 || !hasDocValues) {
            return false;
        }
        type = ArrayType.unnest(type);
        switch (type.id()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                return true;
            }
            case 22: {
                NumericType numericType = (NumericType)type;
                Integer precision = numericType.numericPrecision();
                return precision != null && precision <= 18;
            }
        }
        return false;
    }

    private static IntUnaryOperator getNumNullTermsPerDocFunction(LeafReader reader, Reference ref, Function<ColumnIdent, Reference> getRef) {
        return NumNullTermsPerDocQuery.numValuesPerDocForSortedNumeric(reader, ref, getRef);
    }

    private static IntUnaryOperator numValuesPerDocForSortedNumeric(LeafReader reader, Reference ref, Function<ColumnIdent, Reference> getRef) {
        SortedNumericDocValues numAllTerms;
        SortedNumericDocValues numNonNullTerms;
        try {
            numNonNullTerms = DocValues.getSortedNumeric((LeafReader)reader, (String)ref.storageIdent());
            numAllTerms = DocValues.getSortedNumeric((LeafReader)reader, (String)ArrayIndexer.toArrayLengthFieldName(ref, getRef));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return doc -> {
            try {
                return numAllTerms.advanceExact(doc) && numNonNullTerms.advanceExact(doc) ? Math.toIntExact(numAllTerms.nextValue() - (long)numNonNullTerms.docValueCount()) : -1;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private NumNullTermsPerDocQuery(Reference ref, Function<ColumnIdent, Reference> getRef, IntPredicate matches) {
        super(ref.storageIdent(), (LeafReaderContext leafReaderContext) -> NumNullTermsPerDocQuery.getNumNullTermsPerDocFunction(leafReaderContext.reader(), ref, getRef), matches);
    }

    @Override
    public String toString(String field) {
        return "NumNullTermsPerDoc: " + this.column;
    }
}

