/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.metadata.Reference;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.NumericType;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class NumTermsPerDocQuery
extends Query {
    protected final String column;
    private final Function<LeafReaderContext, IntUnaryOperator> numTermsPerDocFactory;
    private final IntPredicate matches;

    public static NumTermsPerDocQuery forRef(Reference ref, IntPredicate valueCountIsMatch) {
        return new NumTermsPerDocQuery(ref.storageIdent(), leafReaderContext -> NumTermsPerDocQuery.getNumTermsPerDocFunction(leafReaderContext.reader(), ref.storageIdent(), ref.valueType()), valueCountIsMatch);
    }

    public static NumTermsPerDocQuery forColumn(String column, DataType<?> type, IntPredicate valueCountIsMatch) {
        return new NumTermsPerDocQuery(column, leafReaderContext -> NumTermsPerDocQuery.getNumTermsPerDocFunction(leafReaderContext.reader(), column, type), valueCountIsMatch);
    }

    private static IntUnaryOperator getNumTermsPerDocFunction(LeafReader reader, String column, DataType<?> type) {
        DataType<?> elementType = ArrayType.unnest(type);
        switch (elementType.id()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                return NumTermsPerDocQuery.numValuesPerDocForSortedNumeric(reader, column);
            }
            case 22: {
                NumericType numericType = (NumericType)elementType;
                Integer precision = numericType.numericPrecision();
                if (precision == null || precision > 18) {
                    return NumTermsPerDocQuery.numValuesPerDocForSortedSetDocValues(reader, column);
                }
                return NumTermsPerDocQuery.numValuesPerDocForSortedNumeric(reader, column);
            }
            case 4: 
            case 5: 
            case 25: 
            case 27: {
                return NumTermsPerDocQuery.numValuesPerDocForSortedSetDocValues(reader, column);
            }
        }
        throw new UnsupportedOperationException("NYI: " + String.valueOf(elementType));
    }

    private static IntUnaryOperator numValuesPerDocForSortedSetDocValues(LeafReader reader, String column) {
        SortedSetDocValues docValues;
        try {
            docValues = DocValues.getSortedSet((LeafReader)reader, (String)column);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return doc -> {
            try {
                return docValues.advanceExact(doc) ? docValues.docValueCount() : 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static IntUnaryOperator numValuesPerDocForSortedNumeric(LeafReader reader, String column) {
        SortedNumericDocValues sortedNumeric;
        try {
            sortedNumeric = DocValues.getSortedNumeric((LeafReader)reader, (String)column);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return doc -> {
            try {
                return sortedNumeric.advanceExact(doc) ? sortedNumeric.docValueCount() : 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    NumTermsPerDocQuery(String column, Function<LeafReaderContext, IntUnaryOperator> numTermsPerDocFactory, IntPredicate matches) {
        this.column = column;
        this.numTermsPerDocFactory = numTermsPerDocFactory;
        this.matches = matches;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ NumTermsPerDocQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) {
                return new ScorerSupplier(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Scorer get(long leadCost) {
                        NumTermsPerDocTwoPhaseIterator twoPhase = new NumTermsPerDocTwoPhaseIterator(context.reader(), this.this$1.this$0.numTermsPerDocFactory.apply(context), this.this$1.this$0.matches);
                        return new ConstantScoreScorer(0.0f, scoreMode, (TwoPhaseIterator)twoPhase);
                    }

                    public long cost() {
                        return context.reader().maxDoc();
                    }
                };
            }
        };
    }

    public void visit(QueryVisitor visitor) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NumTermsPerDocQuery that = (NumTermsPerDocQuery)((Object)o);
        if (!this.numTermsPerDocFactory.equals(that.numTermsPerDocFactory)) {
            return false;
        }
        return this.matches.equals(that.matches);
    }

    public int hashCode() {
        int result = this.numTermsPerDocFactory.hashCode();
        result = 31 * result + this.matches.hashCode();
        return result;
    }

    public String toString(String field) {
        return "NumTermsPerDoc: " + this.column;
    }

    static class NumTermsPerDocTwoPhaseIterator
    extends TwoPhaseIterator {
        private final IntUnaryOperator numTermsOfDoc;
        private final IntPredicate matches;

        NumTermsPerDocTwoPhaseIterator(LeafReader reader, IntUnaryOperator numTermsOfDoc, IntPredicate matches) {
            super(DocIdSetIterator.all((int)reader.maxDoc()));
            this.numTermsOfDoc = numTermsOfDoc;
            this.matches = matches;
        }

        public boolean matches() {
            int doc = this.approximation.docID();
            return this.matches.test(this.numTermsOfDoc.applyAsInt(doc));
        }

        public float matchCost() {
            return 2.0f;
        }
    }
}

