/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.SubscriptFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import io.crate.types.UndefinedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class SubscriptObjectFunction
extends Scalar<Object, Map<String, Object>> {
    public static final String NAME = "subscript_obj";
    public static final Signature SIGNATURE = Signature.builder("subscript_obj", FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNDEFINED.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).setVariableArity(true).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, SubscriptObjectFunction::new);
    }

    private SubscriptObjectFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function func, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol result = SubscriptObjectFunction.evaluateIfLiterals(this, txnCtx, nodeCtx, func);
        if (result instanceof Literal) {
            return result;
        }
        return SubscriptObjectFunction.tryToInferReturnTypeFromObjectTypeAndArguments(func);
    }

    static Symbol tryToInferReturnTypeFromObjectTypeAndArguments(Function func) {
        if (!func.valueType().equals(DataTypes.UNDEFINED)) {
            return func;
        }
        List<Symbol> arguments = func.arguments();
        ObjectType objectType = (ObjectType)arguments.get(0).valueType();
        List<String> path = SubscriptObjectFunction.maybeCreatePath(arguments);
        if (path == null) {
            return func;
        }
        DataType<?> returnType = objectType.innerType(path);
        return returnType.equals(DataTypes.UNDEFINED) ? func : new Function(func.signature(), func.arguments(), returnType);
    }

    @Nullable
    private static List<String> maybeCreatePath(List<Symbol> arguments) {
        ArrayList<String> path = null;
        for (int i = 1; i < arguments.size(); ++i) {
            Symbol arg = arguments.get(i);
            if (arg instanceof Literal) {
                if (path == null) {
                    path = new ArrayList<String>();
                }
            } else {
                return null;
            }
            path.add(DataTypes.STRING.sanitizeValue(((Literal)arg).value()));
        }
        return path;
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext ndeCtx, Input<Map<String, Object>> ... args) {
        assert (args.length >= 2) : "subscript_obj takes 2 or more arguments, got " + args.length;
        Object mapValue = args[0].value();
        ObjectType objectType = (ObjectType)this.boundSignature.argTypes().getFirst();
        for (int i = 1; i < args.length; ++i) {
            if (mapValue == null) {
                return null;
            }
            String innerValue = DataTypes.STRING.sanitizeValue(args[i].value());
            mapValue = SubscriptFunction.lookupByName(List.of(objectType, DataTypes.STRING), mapValue, innerValue, txnCtx.sessionSettings().errorOnUnknownObjectKey());
            if (mapValue == null) {
                return null;
            }
            DataType<?> innerType = ArrayType.unnest(objectType.innerType(innerValue));
            if (innerType instanceof ObjectType) {
                ObjectType objectType1;
                objectType = objectType1 = (ObjectType)innerType;
                continue;
            }
            if (i >= args.length - 1) continue;
            assert (innerType instanceof UndefinedType);
            objectType = ObjectType.of(objectType.columnPolicy()).build();
        }
        return mapValue;
    }
}

