/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import com.carrotsearch.hppc.CharObjectHashMap;
import com.carrotsearch.hppc.CharObjectMap;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampFormatter {
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final CharObjectMap<FormatTimestampPartFunction> PART_FORMATTERS = new CharObjectHashMap();

    private static void addFormatter(char character, FormatTimestampPartFunction fun) {
        PART_FORMATTERS.put(character, (Object)fun);
    }

    private static String zeroPadded(int to, String val) {
        int length = val.length();
        if (length >= to) {
            return val;
        }
        char[] padded = new char[to];
        Arrays.fill(padded, '0');
        val.getChars(0, length, padded, Math.max(0, to - length));
        return new String(padded);
    }

    public static String format(String formatString, DateTime timestamp) {
        int length = formatString.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean percentEscape = false;
        for (int i = 0; i < length; ++i) {
            char current = formatString.charAt(i);
            if (current == '%') {
                if (!percentEscape) {
                    percentEscape = true;
                    continue;
                }
                buffer.append('%');
                percentEscape = false;
                continue;
            }
            if (percentEscape) {
                FormatTimestampPartFunction partFormatter = (FormatTimestampPartFunction)PART_FORMATTERS.get(current);
                if (partFormatter == null) {
                    buffer.append(current);
                } else {
                    buffer.append(partFormatter.format(timestamp));
                }
            } else {
                buffer.append(current);
            }
            percentEscape = false;
        }
        return buffer.toString();
    }

    static {
        TimestampFormatter.addFormatter('a', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.dayOfWeek().getAsShortText(LOCALE);
            }
        });
        TimestampFormatter.addFormatter('b', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.monthOfYear().getAsShortText(LOCALE);
            }
        });
        TimestampFormatter.addFormatter('c', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return String.valueOf(timestamp.monthOfYear().get());
            }
        });
        TimestampFormatter.addFormatter('D', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                int n = timestamp.dayOfMonth().get();
                StringBuilder builder = new StringBuilder(n > 9 ? 4 : 3);
                builder.append(n);
                if (n >= 11 && n <= 13) {
                    builder.append("th");
                } else {
                    switch (n % 10) {
                        case 1: {
                            builder.append("st");
                            break;
                        }
                        case 2: {
                            builder.append("nd");
                            break;
                        }
                        case 3: {
                            builder.append("rd");
                            break;
                        }
                        default: {
                            builder.append("th");
                        }
                    }
                }
                return builder.toString();
            }
        });
        TimestampFormatter.addFormatter('d', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                String dayOfMonth = String.valueOf(timestamp.dayOfMonth().get());
                return TimestampFormatter.zeroPadded(2, dayOfMonth);
            }
        });
        TimestampFormatter.addFormatter('e', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return String.valueOf(timestamp.dayOfMonth().get());
            }
        });
        TimestampFormatter.addFormatter('f', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return TimestampFormatter.zeroPadded(6, String.valueOf(timestamp.millisOfSecond().get() * 1000));
            }
        });
        final FormatTimestampPartFunction padded24HourFunction = new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                int hourOfDay = timestamp.getHourOfDay() % 24;
                return TimestampFormatter.zeroPadded(2, String.valueOf(hourOfDay));
            }
        };
        TimestampFormatter.addFormatter('H', padded24HourFunction);
        final FormatTimestampPartFunction padded12HourFunction = new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                int hourOfDay = timestamp.getHourOfDay() % 12;
                if (hourOfDay == 0) {
                    hourOfDay = 12;
                }
                return TimestampFormatter.zeroPadded(2, String.valueOf(hourOfDay));
            }
        };
        TimestampFormatter.addFormatter('h', padded12HourFunction);
        TimestampFormatter.addFormatter('I', padded12HourFunction);
        TimestampFormatter.addFormatter('i', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return TimestampFormatter.zeroPadded(2, timestamp.minuteOfHour().getAsShortText(LOCALE));
            }
        });
        TimestampFormatter.addFormatter('j', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return TimestampFormatter.zeroPadded(3, timestamp.dayOfYear().getAsShortText(LOCALE));
            }
        });
        TimestampFormatter.addFormatter('k', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.hourOfDay().getAsShortText(LOCALE);
            }
        });
        TimestampFormatter.addFormatter('l', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                int hourOfDay = timestamp.getHourOfDay() % 12;
                if (hourOfDay == 0) {
                    hourOfDay = 12;
                }
                return String.valueOf(hourOfDay);
            }
        });
        TimestampFormatter.addFormatter('M', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.monthOfYear().getAsText(LOCALE);
            }
        });
        TimestampFormatter.addFormatter('m', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return TimestampFormatter.zeroPadded(2, String.valueOf(timestamp.monthOfYear().get()));
            }
        });
        final FormatTimestampPartFunction amPmFunc = new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.getHourOfDay() < 12 ? "AM" : "PM";
            }
        };
        TimestampFormatter.addFormatter('p', amPmFunc);
        final FormatTimestampPartFunction paddedMinuteFunction = new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return TimestampFormatter.zeroPadded(2, timestamp.minuteOfHour().getAsShortText(LOCALE));
            }
        };
        final FormatTimestampPartFunction paddedSecondFunction = new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return TimestampFormatter.zeroPadded(2, timestamp.secondOfMinute().getAsShortText(LOCALE));
            }
        };
        TimestampFormatter.addFormatter('r', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return padded12HourFunction.format(timestamp) + ":" + paddedMinuteFunction.format(timestamp) + ":" + paddedSecondFunction.format(timestamp) + " " + amPmFunc.format(timestamp);
            }
        });
        TimestampFormatter.addFormatter('s', paddedSecondFunction);
        TimestampFormatter.addFormatter('S', paddedSecondFunction);
        TimestampFormatter.addFormatter('T', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return padded24HourFunction.format(timestamp) + ":" + paddedMinuteFunction.format(timestamp) + ":" + paddedSecondFunction.format(timestamp);
            }
        });
        TimestampFormatter.addFormatter('U', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                Calendar c = Calendar.getInstance(timestamp.getZone().toTimeZone(), LOCALE);
                c.setFirstDayOfWeek(1);
                c.setMinimalDaysInFirstWeek(7);
                c.setTimeInMillis(timestamp.getMillis());
                int week = c.get(3);
                int weekYear = c.getWeekYear();
                int year = c.get(1);
                if (weekYear < year) {
                    week = 0;
                } else if (weekYear > year) {
                    week = c.getWeeksInWeekYear();
                }
                return TimestampFormatter.zeroPadded(2, String.valueOf(week));
            }
        });
        TimestampFormatter.addFormatter('u', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                Calendar c = Calendar.getInstance(timestamp.getZone().toTimeZone(), LOCALE);
                c.setFirstDayOfWeek(2);
                c.setMinimalDaysInFirstWeek(4);
                c.setTimeInMillis(timestamp.getMillis());
                int week = c.get(3);
                int weekYear = c.getWeekYear();
                int year = c.get(1);
                if (weekYear < year) {
                    week = 0;
                } else if (weekYear > year) {
                    week = c.getWeeksInWeekYear();
                }
                return TimestampFormatter.zeroPadded(2, String.valueOf(week));
            }
        });
        TimestampFormatter.addFormatter('V', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                Calendar c = Calendar.getInstance(timestamp.getZone().toTimeZone(), LOCALE);
                c.setFirstDayOfWeek(1);
                c.setMinimalDaysInFirstWeek(7);
                c.setTimeInMillis(timestamp.getMillis());
                int week = c.get(3);
                int weekYear = c.getWeekYear();
                int year = c.get(1);
                if (weekYear < year) {
                    c.add(5, -7);
                    week = c.getWeeksInWeekYear();
                }
                return TimestampFormatter.zeroPadded(2, String.valueOf(week));
            }
        });
        TimestampFormatter.addFormatter('v', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                Calendar c = Calendar.getInstance(timestamp.getZone().toTimeZone(), LOCALE);
                c.setFirstDayOfWeek(2);
                c.setMinimalDaysInFirstWeek(4);
                c.setTimeInMillis(timestamp.getMillis());
                int week = c.get(3);
                int weekYear = c.getWeekYear();
                int year = c.get(1);
                if (weekYear < year) {
                    c.add(5, -7);
                    week = c.getWeeksInWeekYear();
                }
                return TimestampFormatter.zeroPadded(2, String.valueOf(week));
            }
        });
        TimestampFormatter.addFormatter('W', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.dayOfWeek().getAsText(LOCALE);
            }
        });
        TimestampFormatter.addFormatter('w', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                int dayOfWeek = timestamp.dayOfWeek().get() % 7;
                return String.valueOf(dayOfWeek);
            }
        });
        TimestampFormatter.addFormatter('X', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                Calendar c = Calendar.getInstance(timestamp.getZone().toTimeZone(), LOCALE);
                c.setFirstDayOfWeek(1);
                c.setMinimalDaysInFirstWeek(7);
                c.setTimeInMillis(timestamp.withZone(DateTimeZone.UTC).getMillis());
                return TimestampFormatter.zeroPadded(4, String.valueOf(c.getWeekYear()));
            }
        });
        TimestampFormatter.addFormatter('x', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                Calendar c = Calendar.getInstance(timestamp.getZone().toTimeZone(), LOCALE);
                c.setFirstDayOfWeek(2);
                c.setMinimalDaysInFirstWeek(4);
                c.setTimeInMillis(timestamp.withZone(DateTimeZone.UTC).getMillis());
                return TimestampFormatter.zeroPadded(4, String.valueOf(c.getWeekYear()));
            }
        });
        TimestampFormatter.addFormatter('Y', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.year().getAsShortText(Locale.ENGLISH);
            }
        });
        TimestampFormatter.addFormatter('y', new FormatTimestampPartFunction(){

            @Override
            public String format(DateTime timestamp) {
                return timestamp.yearOfCentury().getAsShortText(Locale.ENGLISH);
            }
        });
    }

    private static interface FormatTimestampPartFunction {
        public String format(DateTime var1);
    }
}

