/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public final class CeilFunction {
    public static final String CEIL = "ceil";
    public static final String CEILING = "ceiling";

    private CeilFunction() {
    }

    public static void register(Functions.Builder builder) {
        for (DataType<? extends Number> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            DataType<?> returnType = DataTypes.getIntegralReturnType(type);
            assert (returnType != null) : "Could not get integral type of " + String.valueOf(type);
            for (String name : List.of(CEIL, CEILING)) {
                builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(typeSignature).returnType(returnType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Object, Number>((Signature)signature, (BoundSignature)boundSignature, (DataType<Number>)type, x -> returnType.sanitizeValue(Math.ceil(x.doubleValue()))));
            }
        }
        for (String name : List.of(CEIL, CEILING)) {
            builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, (BoundSignature)boundSignature, DataTypes.NUMERIC, x -> x.setScale(0, RoundingMode.CEILING)));
        }
    }
}

