/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.EnumSet;
import java.util.Random;

public class RandomFunction
extends Scalar<Double, Void> {
    public static final String NAME = "random";
    private final Random random = new Random();

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.DOUBLE.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), RandomFunction::new);
    }

    public RandomFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol.arguments().size() == 0) : "function's number of arguments must be 0";
        return symbol;
    }

    @Override
    @SafeVarargs
    public final Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Void> ... args) {
        assert (args.length == 0) : "number of args must be 0";
        return this.random.nextDouble();
    }
}

