/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import ch.obermuhlner.math.big.BigDecimalMath;
import io.crate.expression.scalar.DoubleScalar;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;
import java.math.MathContext;

public final class SquareRootFunction {
    public static final String NAME = "sqrt";

    private SquareRootFunction() {
    }

    public static void register(Functions.Builder builder) {
        for (DataType<? extends Number> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(typeSignature).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new DoubleScalar((Signature)signature, (BoundSignature)boundSignature, SquareRootFunction::sqrt));
        }
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, ignoredBoundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, BoundSignature.sameAsUnbound(signature), DataTypes.NUMERIC, SquareRootFunction::sqrt));
    }

    private static double sqrt(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("cannot take square root of a negative number");
        }
        return Math.sqrt(value);
    }

    private static BigDecimal sqrt(BigDecimal value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("cannot take square root of a negative number");
        }
        return BigDecimalMath.sqrt((BigDecimal)value, (MathContext)MathContext.DECIMAL128);
    }
}

