/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.array;

import io.crate.execution.engine.aggregation.impl.util.KahanSummationForDouble;
import io.crate.execution.engine.aggregation.impl.util.KahanSummationForFloat;
import io.crate.execution.engine.aggregation.impl.util.OverflowAwareMutableLong;
import java.math.BigDecimal;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ArraySummationFunctions {
    private ArraySummationFunctions() {
    }

    @Nullable
    public static BigDecimal sumBigDecimal(List<BigDecimal> values) {
        BigDecimal sum = BigDecimal.ZERO;
        boolean hasNotNull = false;
        for (int i = 0; i < values.size(); ++i) {
            BigDecimal value = values.get(i);
            if (value == null) continue;
            hasNotNull = true;
            sum = sum.add(value);
        }
        return hasNotNull ? sum : null;
    }

    @Nullable
    public static Float sumFloat(List<Float> values) {
        KahanSummationForFloat kahanSummationForFloat = new KahanSummationForFloat();
        float sum = 0.0f;
        boolean hasNotNull = false;
        for (int i = 0; i < values.size(); ++i) {
            Float value = values.get(i);
            if (value == null) continue;
            hasNotNull = true;
            sum = kahanSummationForFloat.sum(sum, value.floatValue());
        }
        return hasNotNull ? Float.valueOf(sum) : null;
    }

    @Nullable
    public static Double sumDouble(List<Double> values) {
        KahanSummationForDouble kahanSummationForDouble = new KahanSummationForDouble();
        double sum = 0.0;
        boolean hasNotNull = false;
        for (int i = 0; i < values.size(); ++i) {
            Double value = values.get(i);
            if (value == null) continue;
            hasNotNull = true;
            sum = kahanSummationForDouble.sum(sum, value);
        }
        return hasNotNull ? Double.valueOf(sum) : null;
    }

    @Nullable
    public static Long sumNumber(List<Number> values) {
        Long sum = 0L;
        boolean hasNotNull = false;
        for (int i = 0; i < values.size(); ++i) {
            Number value = values.get(i);
            if (value == null) continue;
            hasNotNull = true;
            sum = Math.addExact(sum, value.longValue());
        }
        return hasNotNull ? sum : null;
    }

    @Nullable
    public static BigDecimal sumNumberWithOverflow(List<? extends Number> values) {
        OverflowAwareMutableLong overflowAwareMutableLong = new OverflowAwareMutableLong(0L);
        for (int i = 0; i < values.size(); ++i) {
            Number value = values.get(i);
            if (value == null) continue;
            overflowAwareMutableLong.add(value.longValue());
        }
        return overflowAwareMutableLong.hasValue() ? overflowAwareMutableLong.value() : null;
    }
}

