/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.formatting;

import io.crate.data.Input;
import io.crate.expression.scalar.formatting.DateTimeFormatter;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.elasticsearch.common.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

public class ToCharFunction
extends Scalar<String, Object> {
    public static final String NAME = "to_char";
    private final DataType<?> expressionType;
    private final TriFunction<Object, String, DateTimeFormatter, String> evaluatorFunc;
    @Nullable
    private final DateTimeFormatter formatter;

    public static void register(Functions.Builder module) {
        Stream.of(DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ).forEach(type -> module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(type.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new ToCharFunction((Signature)signature, (BoundSignature)boundSignature, ToCharFunction::evaluateTimestamp)));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new ToCharFunction((Signature)signature, (BoundSignature)boundSignature, ToCharFunction::evaluateInterval));
    }

    public ToCharFunction(Signature signature, BoundSignature boundSignature, TriFunction<Object, String, DateTimeFormatter, String> evaluatorFunc) {
        this(signature, boundSignature, evaluatorFunc, null);
    }

    public ToCharFunction(Signature signature, BoundSignature boundSignature, TriFunction<Object, String, DateTimeFormatter, String> evaluatorFunc, @Nullable DateTimeFormatter formatter) {
        super(signature, boundSignature);
        assert (boundSignature.argTypes().size() == 2) : "Number of arguments to to_char must be 2";
        this.expressionType = boundSignature.argTypes().get(0);
        this.evaluatorFunc = evaluatorFunc;
        this.formatter = formatter;
    }

    private static String evaluateTimestamp(Object timestamp, String pattern, @Nullable DateTimeFormatter formatter) {
        if (formatter == null) {
            formatter = new DateTimeFormatter(pattern);
        }
        Long ts = DataTypes.TIMESTAMPZ.sanitizeValue(timestamp);
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), TimeZone.getTimeZone("UTC").toZoneId());
        return formatter.format(dateTime);
    }

    private static String evaluateInterval(Object interval, String pattern, @Nullable DateTimeFormatter formatter) {
        if (formatter == null) {
            formatter = new DateTimeFormatter(pattern);
        }
        Period period = DataTypes.INTERVAL.sanitizeValue(interval);
        LocalDateTime dateTime = LocalDateTime.of(0, 1, 1, 0, 0, 0, 0).plusYears(period.getYears()).plusMonths(period.getMonths()).plusWeeks(period.getWeeks()).plusDays(period.getDays()).plusHours(period.getHours()).plusMinutes(period.getMinutes()).plusSeconds(period.getSeconds()).plusNanos((long)period.getMillis() * 1000000L);
        return formatter.format(dateTime);
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        Object expression = this.expressionType.sanitizeValue(args[0].value());
        String pattern = DataTypes.STRING.sanitizeValue(args[1].value());
        if (expression == null) {
            return null;
        }
        if (pattern == null) {
            return null;
        }
        return this.evaluatorFunc.apply(expression, pattern, this.formatter);
    }

    @Override
    public Scalar<String, Object> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        assert (arguments.size() == 2) : "Invalid number of arguments";
        if (!arguments.get(1).symbolType().isValueSymbol()) {
            return this;
        }
        String pattern = (String)((Input)arguments.get(1)).value();
        DateTimeFormatter formatter = new DateTimeFormatter(pattern);
        return new ToCharFunction(this.signature, this.boundSignature, this.evaluatorFunc, formatter);
    }
}

