/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.object;

import io.crate.data.Input;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.ObjectType;
import java.util.HashMap;
import java.util.Map;

public class ObjectMergeFunction
extends Scalar<Map<String, Object>, Map<String, Object>> {
    public static DataType<?> merge(DataType<?> left, DataType<?> right) {
        if (!(left instanceof ObjectType)) {
            return right;
        }
        if (!(right instanceof ObjectType)) {
            return left;
        }
        return ObjectType.merge((ObjectType)left, (ObjectType)right, (l, r) -> r, right.columnPolicy());
    }

    public ObjectMergeFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Map<String, Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Map<String, Object>> ... args) {
        Map objectOne = (Map)args[0].value();
        Map objectTwo = (Map)args[1].value();
        if (objectOne == null) {
            return objectTwo;
        }
        if (objectTwo == null) {
            return objectOne;
        }
        HashMap<String, Object> resultObject = new HashMap<String, Object>();
        resultObject.putAll(objectOne);
        resultObject.putAll(objectTwo);
        return resultObject;
    }
}

