/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.common.StringUtils;
import io.crate.data.Input;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.sql.tree.TrimMode;
import io.crate.types.DataTypes;
import java.util.HashSet;
import java.util.List;
import java.util.function.BinaryOperator;

public final class TrimFunctions {
    private static final String TRIM_NAME = "trim";
    private static final String LTRIM_NAME = "ltrim";
    private static final String RTRIM_NAME = "rtrim";
    private static final String BTRIM_NAME = "btrim";

    private TrimFunctions() {
    }

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(TRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new OneCharTrimFunction((Signature)signature, (BoundSignature)boundSignature, ' '));
        module.add(Signature.builder(TRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), TrimFunction::new);
        module.add(Signature.builder(LTRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new SideTrimFunction((Signature)signature, (BoundSignature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.LEADING)));
        module.add(Signature.builder(LTRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new SideTrimFunction((Signature)signature, (BoundSignature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.LEADING)));
        module.add(Signature.builder(RTRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new SideTrimFunction((Signature)signature, (BoundSignature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.TRAILING)));
        module.add(Signature.builder(RTRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new SideTrimFunction((Signature)signature, (BoundSignature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.TRAILING)));
        module.add(Signature.builder(BTRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new SideTrimFunction((Signature)signature, (BoundSignature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.BOTH)));
        module.add(Signature.builder(BTRIM_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new SideTrimFunction((Signature)signature, (BoundSignature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.BOTH)));
    }

    private static String trimChars(String target, String charsToTrimArg, TrimMode mode) {
        int len;
        HashSet<Character> charsToTrim = new HashSet<Character>();
        for (char c : charsToTrimArg.toCharArray()) {
            charsToTrim.add(Character.valueOf(c));
        }
        int start = mode.getStartIdx(target, charsToTrim);
        return start < (len = mode.getTrimmedLength(target, charsToTrim)) ? target.substring(start, len) : "";
    }

    private static class SideTrimFunction
    extends Scalar<String, String> {
        private final BinaryOperator<String> trimFunction;

        SideTrimFunction(Signature signature, BoundSignature boundSignature, BinaryOperator<String> function) {
            super(signature, boundSignature);
            this.trimFunction = function;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            assert (args.length == 1 || args.length == 2) : "number of args must be 1 or 2";
            String target = (String)args[0].value();
            if (target == null) {
                return null;
            }
            if (args.length == 2) {
                String passedTrimmingText = (String)args[1].value();
                if (passedTrimmingText == null) {
                    return null;
                }
                return (String)this.trimFunction.apply(target, passedTrimmingText);
            }
            return (String)this.trimFunction.apply(target, " ");
        }
    }

    private static class OneCharTrimFunction
    extends Scalar<String, String> {
        private final char charToTrim;

        OneCharTrimFunction(Signature signature, BoundSignature boundSignature, char charToTrim) {
            super(signature, boundSignature);
            this.charToTrim = charToTrim;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            String target = (String)args[0].value();
            if (target == null) {
                return null;
            }
            return StringUtils.trim((String)target, (char)this.charToTrim);
        }
    }

    private static class TrimFunction
    extends Scalar<String, String> {
        TrimFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public Scalar<String, String> compile(List<Symbol> arguments, String currentUser, Roles roles) {
            assert (arguments.size() == 3) : "number of args must be 3";
            Symbol modeSymbol = arguments.get(2);
            if (!Symbol.isLiteral(modeSymbol, DataTypes.STRING)) {
                return this;
            }
            TrimMode mode = TrimMode.of((String)((String)((Input)modeSymbol).value()));
            if (mode != TrimMode.BOTH) {
                return this;
            }
            Symbol charsToTrimSymbol = arguments.get(1);
            if (!Symbol.isLiteral(charsToTrimSymbol, DataTypes.STRING)) {
                return this;
            }
            String charsToTrim = (String)((Input)charsToTrimSymbol).value();
            if (charsToTrim != null && charsToTrim.length() == 1) {
                return new OneCharTrimFunction(this.signature, this.boundSignature, charsToTrim.charAt(0));
            }
            return this;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            assert (args.length == 3) : "number of args must be 3";
            String target = (String)args[0].value();
            if (target == null) {
                return null;
            }
            String charsToTrimArg = (String)args[1].value();
            if (charsToTrimArg == null) {
                return null;
            }
            TrimMode mode = TrimMode.of((String)((String)args[2].value()));
            return TrimFunctions.trimChars(target, charsToTrimArg, mode);
        }
    }
}

