/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol.format;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.format.Style;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MatchPrinter {
    private MatchPrinter() {
    }

    public static void printMatchPredicate(Function matchPredicate, Style style, StringBuilder sb) {
        List<Symbol> arguments = matchPredicate.arguments();
        sb.append("MATCH((");
        MatchPrinter.printColumns(arguments.get(0), sb);
        sb.append("), ");
        sb.append(arguments.get(1).toString(style));
        sb.append(") USING ");
        sb.append((String)((Literal)arguments.get(2)).value());
        MatchPrinter.printProperties(arguments.get(3), sb);
    }

    private static void printColumns(Symbol cols, StringBuilder sb) {
        Map columnBootMap = (Map)((Literal)cols).value();
        Iterator entryIterator = columnBootMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            sb.append((String)entry.getKey());
            Object boost = entry.getValue();
            if (boost != null) {
                sb.append(" ").append(boost);
            }
            if (!entryIterator.hasNext()) continue;
            sb.append(", ");
        }
    }

    private static void printProperties(Symbol propSymbol, StringBuilder sb) {
        Map properties = (Map)((Literal)propSymbol).value();
        if (properties.isEmpty()) {
            return;
        }
        sb.append(" WITH (");
        Iterator it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(" = ");
            Object value = entry.getValue();
            if (value != null) {
                sb.append("'");
                sb.append(value);
                sb.append("'");
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
    }
}

