/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.DataType;
import io.crate.types.RowType;
import java.util.List;
import java.util.Locale;

public class TableFunctionFactory {
    public static TableFunctionImplementation<?> from(FunctionImplementation functionImplementation) {
        return switch (functionImplementation.signature().getType()) {
            case FunctionType.TABLE -> (ScalarTableFunctionImplementation)functionImplementation;
            case FunctionType.SCALAR -> new ScalarTableFunctionImplementation((Scalar)functionImplementation);
            case FunctionType.WINDOW, FunctionType.AGGREGATE -> throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Window or Aggregate function: '%s' is not allowed in function in FROM clause", functionImplementation.signature().getName().displayName()));
            default -> throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unknown type function: '%s' is not allowed in function in FROM clause", functionImplementation.signature().getName().displayName()));
        };
    }

    private static class ScalarTableFunctionImplementation<T>
    extends TableFunctionImplementation<T> {
        private final Scalar<?, T> functionImplementation;
        private final RowType returnType;

        private ScalarTableFunctionImplementation(Scalar<?, T> functionImplementation) {
            super(Signature.builder(functionImplementation.signature().getName(), FunctionType.TABLE).argumentTypes(functionImplementation.signature().getArgumentTypes()).returnType(functionImplementation.signature().getReturnType()).features(Scalar.Feature.DETERMINISTIC).build(), new BoundSignature(functionImplementation.boundSignature().argTypes(), functionImplementation.boundSignature().returnType()));
            this.functionImplementation = functionImplementation;
            DataType<?> boundReturnType = functionImplementation.boundSignature().returnType();
            this.returnType = new RowType(List.of(boundReturnType), List.of(functionImplementation.signature().getName().name()));
        }

        @Override
        public Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T>[] args) {
            return List.of(new Row1(this.functionImplementation.evaluate(txnCtx, nodeCtx, args)));
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return true;
        }
    }
}

