/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.UserMappingAlreadyExists;
import io.crate.metadata.information.UserMappingOptionsTableInfo;
import io.crate.metadata.information.UserMappingsTableInfo;
import io.crate.server.xcontent.XContentParserUtils;
import io.crate.sql.tree.CascadeMode;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ServersMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom,
Iterable<Server> {
    public static final String TYPE = "servers";
    public static final ServersMetadata EMPTY = new ServersMetadata(Map.of());
    private final Map<String, Server> servers;

    ServersMetadata(Map<String, Server> servers) {
        this.servers = servers;
    }

    public ServersMetadata(StreamInput in) throws IOException {
        this.servers = in.readMap(StreamInput::readString, Server::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.servers, StreamOutput::writeString, (o, value) -> value.writeTo(o));
    }

    public static ServersMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Server> servers = new HashMap<String, Server>();
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
            assert (parser.currentName().endsWith(TYPE)) : "toXContent starts with startObject(TYPE)";
            parser.nextToken();
        }
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
            String serverName = parser.currentName();
            parser.nextToken();
            Server server = Server.fromXContent(parser);
            servers.put(serverName, server);
        }
        parser.nextToken();
        return new ServersMetadata(servers);
    }

    public boolean contains(String name) {
        return this.servers.containsKey(name);
    }

    public ServersMetadata add(String name, String fdw, String owner, Settings options) {
        Server server = new Server(name, fdw, owner, Map.of(), options);
        return this.put(name, server);
    }

    public ServersMetadata put(String name, Server server) {
        HashMap<String, Server> servers = new HashMap<String, Server>(this.servers);
        servers.put(name, server);
        return new ServersMetadata(servers);
    }

    public ServersMetadata addUser(String serverName, boolean ifNotExists, String userName, Settings options) {
        Server server = this.get(serverName);
        if (server.users.containsKey(userName)) {
            if (ifNotExists) {
                return this;
            }
            throw new UserMappingAlreadyExists(userName, serverName);
        }
        HashMap<String, Server> newServers = new HashMap<String, Server>(this.servers);
        HashMap<String, Settings> newUsers = new HashMap<String, Settings>(server.users);
        newUsers.put(userName, options);
        Server newServer = new Server(serverName, server.fdw, server.owner, newUsers, server.options);
        newServers.put(serverName, newServer);
        return new ServersMetadata(newServers);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_5_7_0;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    public Server get(String serverName) {
        Server server = this.servers.get(serverName);
        if (server == null) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Server `%s` not found", serverName), new Object[0]);
        }
        return server;
    }

    @Override
    public Iterator<Server> iterator() {
        return this.servers.values().iterator();
    }

    public ServersMetadata remove(List<String> names, boolean ifExists, CascadeMode mode) {
        HashMap<String, Server> newServers = new HashMap<String, Server>(this.servers);
        for (String serverName : names) {
            Server removed = (Server)newServers.remove(serverName);
            if (removed == null) {
                if (ifExists) continue;
                throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Server `%s` not found", serverName), new Object[0]);
            }
            if (mode != CascadeMode.RESTRICT || removed.users().isEmpty()) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot drop server `%s` because mapped users (%s) depend on it", serverName, String.join((CharSequence)", ", removed.users().keySet())));
        }
        return newServers.size() == this.servers.size() ? this : new ServersMetadata(newServers);
    }

    public ServersMetadata dropUser(String serverName, String userName, boolean ifExists) {
        Server server = this.get(serverName);
        HashMap<String, Settings> newUsers = new HashMap<String, Settings>(server.users);
        Settings removed = newUsers.remove(userName);
        if (removed == null && !ifExists) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "No user mapping found for user `%s` and server `%s`", userName, serverName), new Object[0]);
        }
        if (newUsers.size() == server.users.size()) {
            return this;
        }
        HashMap<String, Server> newServers = new HashMap<String, Server>(this.servers);
        Server newServer = new Server(serverName, server.fdw, server.owner, newUsers, server.options);
        newServers.replace(serverName, newServer);
        return new ServersMetadata(newServers);
    }

    public int hashCode() {
        return this.servers.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ServersMetadata)) return false;
        ServersMetadata other = (ServersMetadata)obj;
        if (!this.servers.equals(other.servers)) return false;
        return true;
    }

    public Iterable<UserMappingsTableInfo.UserMapping> getUserMappings() {
        return () -> this.servers.values().stream().map(server -> server).flatMap(server -> server.users.keySet().stream().map(userName -> new UserMappingsTableInfo.UserMapping((String)userName, server.name()))).iterator();
    }

    public Iterable<UserMappingOptionsTableInfo.UserMappingOptions> getUserMappingOptions() {
        return () -> this.servers.values().stream().map(server -> server).flatMap(server -> server.users.entrySet().stream().flatMap(e -> ((Settings)e.getValue()).getAsStructuredMap().entrySet().stream().map(setting -> new UserMappingOptionsTableInfo.UserMappingOptions((String)e.getKey(), server.name(), (String)setting.getKey(), setting.getValue().toString())))).iterator();
    }

    public Iterable<Server.Option> getOptions() {
        return () -> this.servers.values().stream().flatMap(server -> server.getOptions()).iterator();
    }

    public record Server(String name, String fdw, String owner, Map<String, Settings> users, Settings options) implements Writeable
    {
        public Server(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), in.readString(), in.readMap(StreamInput::readString, Settings::readSettingsFromStream), Settings.readSettingsFromStream(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.fdw);
            out.writeString(this.owner);
            out.writeMap(this.users, StreamOutput::writeString, Settings::writeSettingsToStream);
            Settings.writeSettingsToStream(out, this.options);
        }

        public static Server fromXContent(XContentParser parser) throws IOException {
            String name = null;
            String fdw = null;
            String owner = null;
            HashMap<String, Settings> users = new HashMap<String, Settings>();
            Settings options = null;
            block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
                String fieldName = parser.currentName();
                parser.nextToken();
                switch (fieldName) {
                    case "name": {
                        name = parser.text();
                        continue block14;
                    }
                    case "fdw": {
                        fdw = parser.text();
                        continue block14;
                    }
                    case "owner": {
                        owner = parser.text();
                        continue block14;
                    }
                    case "users": {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
                        parser.nextToken();
                        while (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                            parser.nextToken();
                            String key = parser.currentName();
                            Settings settings = Settings.fromXContent(parser);
                            users.put(key, settings);
                            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.currentToken(), parser);
                            parser.nextToken();
                        }
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.currentToken(), parser);
                        continue block14;
                    }
                    case "options": {
                        options = Settings.fromXContent(parser);
                        continue block14;
                    }
                }
                parser.skipChildren();
            }
            return new Server(Objects.requireNonNull(name), Objects.requireNonNull(fdw), Objects.requireNonNull(owner), Objects.requireNonNull(users), Objects.requireNonNull(options));
        }

        public Stream<Option> getOptions() {
            return this.options.getAsStructuredMap().entrySet().stream().map(x -> new Option(this.name, this.owner, (String)x.getKey(), DataTypes.STRING.implicitCast(x.getValue())));
        }

        public Server withOptions(Settings options) {
            return new Server(this.name, this.fdw, this.owner, this.users, options);
        }

        public record Option(String serverName, String serverOwner, String name, String value) {
        }
    }
}

