/*
 * Decompiled with CFR 0.152.
 */
package io.crate.interval;

import io.crate.interval.NumericalIntervalParser;
import io.crate.interval.PGIntervalParser;
import io.crate.interval.SQLStandardIntervalParser;
import java.math.BigDecimal;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.format.ISOPeriodFormat;

public final class IntervalParser {
    private IntervalParser() {
    }

    public static Period apply(String value) {
        return IntervalParser.apply(value, null, null);
    }

    public static Period apply(String value, @Nullable Precision start, @Nullable Precision end) {
        Period result;
        if (value == null || value.isEmpty() || value.isBlank()) {
            throw new IllegalArgumentException("Invalid interval format:  " + value);
        }
        try {
            result = NumericalIntervalParser.apply(value, start, end);
        }
        catch (IllegalArgumentException e1) {
            try {
                result = IntervalParser.roundToPrecision(ISOPeriodFormat.standard().parsePeriod(value), start, end);
            }
            catch (IllegalArgumentException e2) {
                try {
                    result = SQLStandardIntervalParser.apply(value, start, end);
                }
                catch (IllegalArgumentException e3) {
                    result = PGIntervalParser.apply(value, start, end);
                }
            }
        }
        return result.normalizedStandard(PeriodType.yearMonthDayTime());
    }

    static Period roundToPrecision(Period period, Precision start, Precision end) {
        if (start == null && end == null) {
            return period;
        }
        if (start == Precision.YEAR) {
            if (end == null) {
                return Period.years((int)period.getYears());
            }
            if (end == Precision.MONTH) {
                return Period.years((int)period.getYears()).withMonths(period.getMonths());
            }
        }
        if (start == Precision.MONTH && end == null) {
            return Period.years((int)period.getYears()).withMonths(period.getMonths());
        }
        if (start == Precision.DAY) {
            if (end == null) {
                return period.withHours(0).withMinutes(0).withSeconds(0).withMillis(0);
            }
            if (end == Precision.HOUR) {
                return period.withMinutes(0).withSeconds(0).withMillis(0);
            }
            if (end == Precision.MINUTE) {
                return period.withSeconds(0).withMillis(0);
            }
            if (end == Precision.SECOND) {
                return period.withMillis(0);
            }
        }
        if (start == Precision.HOUR) {
            if (end == null) {
                return period.withMinutes(0).withSeconds(0).withMillis(0);
            }
            if (end == Precision.MINUTE) {
                return period.withSeconds(0).withMillis(0);
            }
            if (end == Precision.SECOND) {
                return period.withMillis(0);
            }
        }
        if (start == Precision.MINUTE) {
            if (end == null) {
                return period.withSeconds(0).withMillis(0);
            }
            if (end == Precision.SECOND) {
                return period.withMillis(0);
            }
        }
        if (start == Precision.SECOND && end == null) {
            return period.withMillis(0);
        }
        throw new IllegalArgumentException("Invalid start and end combination");
    }

    static int parseMilliSeconds(String value) throws NumberFormatException {
        BigDecimal decimal = new BigDecimal(value);
        return decimal.subtract(new BigDecimal(decimal.intValue())).multiply(new BigDecimal(1000)).intValue();
    }

    static int nullSafeIntGet(String value) {
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static enum Precision {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

