/*
 * Decompiled with CFR 0.152.
 */
package io.crate.interval;

import io.crate.interval.IntervalParser;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

final class PGIntervalParser {
    private PGIntervalParser() {
    }

    static Period apply(String value, @Nullable IntervalParser.Precision start, @Nullable IntervalParser.Precision end) {
        return IntervalParser.roundToPrecision(PGIntervalParser.apply(value), start, end);
    }

    static Period apply(String value) {
        String strInterval = value.trim().toLowerCase(Locale.ENGLISH);
        boolean ISOFormat = !strInterval.startsWith("@");
        boolean hasAgo = strInterval.endsWith("ago");
        strInterval = strInterval.replace("+", "").replace("@", "").replace("ago", "").trim();
        if (!ISOFormat && value.length() == 3 && value.charAt(2) == '0') {
            return new Period();
        }
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliSeconds = 0;
        boolean weeksParsed = false;
        boolean daysParsed = false;
        try {
            String unitToken = null;
            boolean timeParsed = false;
            StringTokenizer st = new StringTokenizer(strInterval);
            while (st.hasMoreTokens()) {
                String valueToken;
                String token = st.nextToken();
                int firstCharIdx = PGIntervalParser.firstCharacterInStr(token);
                if (firstCharIdx > 0) {
                    valueToken = token.substring(0, firstCharIdx);
                    unitToken = token.substring(firstCharIdx);
                } else {
                    valueToken = token;
                    if (st.hasMoreTokens()) {
                        unitToken = st.nextToken();
                    }
                }
                int endHours = token.indexOf(58);
                if (endHours > 0) {
                    if (timeParsed) {
                        throw new IllegalArgumentException("Invalid interval format: " + value);
                    }
                    int offset = token.charAt(0) == '-' ? 1 : 0;
                    hours = IntervalParser.nullSafeIntGet(token.substring(offset, endHours));
                    minutes = IntervalParser.nullSafeIntGet(token.substring(endHours + 1, endHours + 3));
                    int endMinutes = token.indexOf(58, endHours + 1);
                    seconds = PGIntervalParser.parseInteger(token.substring(endMinutes + 1));
                    milliSeconds = IntervalParser.parseMilliSeconds(token.substring(endMinutes + 1));
                    if (offset == 1) {
                        hours = -hours;
                        minutes = -minutes;
                        seconds = -seconds;
                        milliSeconds = -milliSeconds;
                    }
                    timeParsed = true;
                } else if (unitToken == null) {
                    throw new IllegalArgumentException("Invalid interval format: " + value);
                }
                if (unitToken != null) {
                    switch (unitToken) {
                        case "year": 
                        case "years": 
                        case "y": {
                            if (years > 0) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            years = IntervalParser.nullSafeIntGet(valueToken);
                            break;
                        }
                        case "month": 
                        case "months": 
                        case "mon": 
                        case "mons": {
                            if (months > 0) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            months = IntervalParser.nullSafeIntGet(valueToken);
                            break;
                        }
                        case "day": 
                        case "days": 
                        case "d": {
                            if (daysParsed) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            days += IntervalParser.nullSafeIntGet(valueToken);
                            daysParsed = true;
                            break;
                        }
                        case "week": 
                        case "weeks": 
                        case "w": {
                            if (weeksParsed) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            days += IntervalParser.nullSafeIntGet(valueToken) * 7;
                            weeksParsed = true;
                            break;
                        }
                        case "hour": 
                        case "hours": 
                        case "h": {
                            if (hours > 0) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            hours = IntervalParser.nullSafeIntGet(valueToken);
                            timeParsed = true;
                            break;
                        }
                        case "min": 
                        case "mins": 
                        case "minute": 
                        case "minutes": 
                        case "m": {
                            if (minutes > 0) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            minutes = IntervalParser.nullSafeIntGet(valueToken);
                            timeParsed = true;
                            break;
                        }
                        case "sec": 
                        case "secs": 
                        case "second": 
                        case "seconds": 
                        case "s": {
                            if (seconds > 0 || milliSeconds > 0) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            seconds = PGIntervalParser.parseInteger(valueToken);
                            milliSeconds = IntervalParser.parseMilliSeconds(valueToken);
                            timeParsed = true;
                            break;
                        }
                        case "ms": 
                        case "msec": 
                        case "msecs": 
                        case "millisecond": 
                        case "milliseconds": {
                            if (milliSeconds > 0) {
                                throw new IllegalArgumentException("Invalid interval format: " + value);
                            }
                            milliSeconds = PGIntervalParser.parseInteger(valueToken);
                            timeParsed = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid interval format: " + value);
                        }
                    }
                }
                unitToken = null;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid interval format: " + value);
        }
        Period period = new Period(years, months, 0, days, hours, minutes, seconds, milliSeconds);
        if (!ISOFormat && hasAgo) {
            period = period.negated();
        }
        return period;
    }

    private static int firstCharacterInStr(String token) {
        for (int i = 0; i < token.length(); ++i) {
            if (!Character.isLetter(token.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static int parseInteger(String value) {
        return new BigDecimal(value).intValue();
    }
}

