/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.common.collections.Maps;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class GeoReference
extends SimpleReference {
    private final String geoTree;
    @Nullable
    private final String precision;
    @Nullable
    private final Integer treeLevels;
    @Nullable
    private final Double distanceErrorPct;

    public GeoReference(ReferenceIdent ident, DataType<?> type, IndexType indexType, boolean nullable, int position, long oid, boolean isDropped, Symbol defaultExpression, String geoTree, String precision, Integer treeLevels, Double distanceErrorPct) {
        super(ident, RowGranularity.DOC, type, indexType, nullable, false, position, oid, isDropped, defaultExpression);
        this.geoTree = Objects.requireNonNullElse(geoTree, "geohash");
        if ("bkdtree".equals(this.geoTree) && (precision != null || treeLevels != null || distanceErrorPct != null)) {
            throw new IllegalArgumentException("The parameters precision, tree_levels, and distance_error_pct are not applicable to BKD tree indexes.");
        }
        this.precision = precision;
        this.treeLevels = treeLevels;
        this.distanceErrorPct = distanceErrorPct;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.GEO_REFERENCE;
    }

    public String geoTree() {
        return this.geoTree;
    }

    @Nullable
    public String precision() {
        return this.precision;
    }

    @Nullable
    public Integer treeLevels() {
        return this.treeLevels;
    }

    @Nullable
    public Double distanceErrorPct() {
        return this.distanceErrorPct;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoReference that = (GeoReference)o;
        return Objects.equals(this.geoTree, that.geoTree) && Objects.equals(this.precision, that.precision) && Objects.equals(this.treeLevels, that.treeLevels) && Objects.equals(this.distanceErrorPct, that.distanceErrorPct);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.geoTree, this.precision, this.treeLevels, this.distanceErrorPct);
    }

    public GeoReference(StreamInput in) throws IOException {
        super(in);
        this.geoTree = in.readString();
        this.precision = in.readOptionalString();
        this.treeLevels = in.readBoolean() ? null : Integer.valueOf(in.readVInt());
        this.distanceErrorPct = in.readBoolean() ? null : Double.valueOf(in.readDouble());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.geoTree);
        out.writeOptionalString(this.precision);
        out.writeBoolean(this.treeLevels == null);
        if (this.treeLevels != null) {
            out.writeVInt(this.treeLevels);
        }
        out.writeBoolean(this.distanceErrorPct == null);
        if (this.distanceErrorPct != null) {
            out.writeDouble(this.distanceErrorPct);
        }
    }

    @Override
    public Reference withReferenceIdent(ReferenceIdent newIdent) {
        return new GeoReference(newIdent, this.type, this.indexType, this.nullable, this.position, this.oid, this.isDropped, this.defaultExpression, this.geoTree, this.precision, this.treeLevels, this.distanceErrorPct);
    }

    @Override
    public Reference withOidAndPosition(LongSupplier acquireOid, IntSupplier acquirePosition) {
        int newPosition;
        long newOid = this.oid == 0L ? acquireOid.getAsLong() : this.oid;
        int n = newPosition = this.position < 0 ? acquirePosition.getAsInt() : this.position;
        if (newOid == this.oid && newPosition == this.position) {
            return this;
        }
        return new GeoReference(this.ident, this.type, this.indexType, this.nullable, newPosition, newOid, this.isDropped, this.defaultExpression, this.geoTree, this.precision, this.treeLevels, this.distanceErrorPct);
    }

    @Override
    public GeoReference withValueType(DataType<?> newType) {
        return new GeoReference(this.ident, newType, this.indexType, this.nullable, this.position, this.oid, this.isDropped, this.defaultExpression, this.geoTree, this.precision, this.treeLevels, this.distanceErrorPct);
    }

    @Override
    public Map<String, Object> toMapping(int position) {
        Map<String, Object> mapping = super.toMapping(position);
        Maps.putNonNull(mapping, (Object)"tree", (Object)this.geoTree);
        Maps.putNonNull(mapping, (Object)"precision", (Object)this.precision);
        Maps.putNonNull(mapping, (Object)"tree_levels", (Object)this.treeLevels);
        if (this.distanceErrorPct != null) {
            mapping.put("distance_error_pct", Float.valueOf(this.distanceErrorPct.floatValue()));
        }
        return mapping;
    }
}

