/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.blob.v2.BlobIndex;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class IndexName {
    private static final Logger LOGGER = LogManager.getLogger(IndexName.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LOGGER);
    private static final String PARTITIONED_KEY_WORD = "partitioned";
    public static final int MAX_INDEX_NAME_BYTES = 255;
    @VisibleForTesting
    static final String PARTITIONED_TABLE_PART = ".partitioned.";

    private IndexName() {
    }

    public static void validate(String indexName) {
        IndexName.validate(indexName, InvalidIndexNameException::new);
    }

    public static void validate(String indexName, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(indexName)) {
            throw exceptionCtor.apply(indexName, "must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS));
        }
        if (indexName.contains("#")) {
            throw exceptionCtor.apply(indexName, "must not contain '#'");
        }
        if (indexName.contains(":")) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("index_name_contains_colon", "index or alias name [" + indexName + "] containing ':' is deprecated. CrateDB 4.x will read, but not allow creation of new indices containing ':'", new Object[0]);
        }
        if (indexName.charAt(0) == '-' || indexName.charAt(0) == '+') {
            throw exceptionCtor.apply(indexName, "must not start with '-', or '+'");
        }
        int byteCount = indexName.getBytes(StandardCharsets.UTF_8).length;
        if (byteCount > 255) {
            throw exceptionCtor.apply(indexName, "index name is too long, (" + byteCount + " > 255)");
        }
        if (indexName.equals(".") || indexName.equals("..")) {
            throw exceptionCtor.apply(indexName, "must not be '.' or '..'");
        }
    }

    public static IndexParts decode(String indexName) {
        if (BlobIndex.isBlobIndex(indexName)) {
            return new IndexParts("blob", BlobIndex.stripPrefix(indexName), null);
        }
        String[] parts = indexName.split("\\.", 6);
        return switch (parts.length) {
            case 1 -> new IndexParts("doc", indexName, null);
            case 2 -> new IndexParts(parts[0], parts[1], null);
            case 4 -> {
                IndexName.assertEmpty(parts[0]);
                IndexName.assertPartitionPrefix(parts[1]);
                yield new IndexParts("doc", parts[2], parts[3]);
            }
            case 5 -> {
                IndexName.assertEmpty(parts[1]);
                IndexName.assertPartitionPrefix(parts[2]);
                yield new IndexParts(parts[0], parts[3], parts[4]);
            }
            default -> throw new IllegalArgumentException("Invalid index name: " + indexName);
        };
    }

    public static String encode(RelationName relationName, String partitionIdent) {
        return IndexName.encode(relationName.schema(), relationName.name(), partitionIdent);
    }

    public static String encode(String schema, String table, @Nullable String partitionIdent) {
        if (partitionIdent == null) {
            if (schema.equals("doc")) {
                return table;
            }
            return schema + "." + table;
        }
        if (schema.equals("doc")) {
            return PARTITIONED_TABLE_PART + table + "." + partitionIdent;
        }
        return schema + "..partitioned." + table + "." + partitionIdent;
    }

    public static boolean isPartitioned(String templateOrIndex) {
        int idx1 = templateOrIndex.indexOf(46);
        if (idx1 == -1) {
            return false;
        }
        int idx2 = templateOrIndex.indexOf(PARTITIONED_TABLE_PART, idx1);
        if (idx2 == -1) {
            return false;
        }
        int diff = idx2 - idx1;
        return (diff == 0 && idx1 == 0 || diff == 1) && idx2 + PARTITIONED_TABLE_PART.length() < templateOrIndex.length();
    }

    public static boolean isDangling(String indexName) {
        return indexName.startsWith(".") && !indexName.startsWith(PARTITIONED_TABLE_PART) && !BlobIndex.isBlobIndex(indexName);
    }

    private static void assertPartitionPrefix(String prefix) {
        if (!PARTITIONED_KEY_WORD.equals(prefix)) {
            throw new IllegalArgumentException("Invalid partition prefix: " + prefix);
        }
    }

    private static void assertEmpty(String prefix) {
        if (!"".equals(prefix)) {
            throw new IllegalArgumentException("Invalid index name: " + prefix);
        }
    }
}

