/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Reference;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ReferenceTree {
    private final Node root;

    public static ReferenceTree of(Collection<Reference> references) {
        Composite root = new Composite("_doc", new HashMap<String, Node>(), null);
        references.stream().sorted(Comparator.comparing(Reference::column)).forEach(r -> ReferenceTree.addReference(root, r, r.column()));
        return new ReferenceTree(root);
    }

    private static void addReference(Composite root, Reference ref, ColumnIdent column) {
        if (column.isRoot()) {
            if (root.children.get(column.name()) == null) {
                root.children.put(column.name(), new Leaf(ref));
            }
        } else {
            ColumnIdent childColumn = column.shiftRight();
            assert (childColumn != null);
            Node node = root.children.get(column.name());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Leaf.class, Composite.class}, (Node)node, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case -1: {
                    Composite child = new Composite(column.name(), new HashMap<String, Node>(), ref);
                    root.children.put(column.name(), child);
                    ReferenceTree.addReference(child, ref, childColumn);
                    break;
                }
                case 0: {
                    Leaf l = (Leaf)node;
                    Composite child = new Composite(column.name(), new HashMap<String, Node>(), l.ref);
                    root.children.put(column.name(), child);
                    ReferenceTree.addReference(child, ref, childColumn);
                    break;
                }
                case 1: {
                    Composite c = (Composite)node;
                    ReferenceTree.addReference(c, ref, childColumn);
                }
            }
        }
    }

    private ReferenceTree(Node root) {
        this.root = root;
    }

    public List<Reference> getChildren(Reference parent) {
        Node ref;
        Node node = ref = this.findRef(parent);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Leaf.class, Composite.class}, (Node)node, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> List.of();
            case 0 -> List.of();
            case 1 -> {
                Composite c = (Composite)node;
                yield c.children.values().stream().map(Node::ref).toList();
            }
        };
    }

    public List<Reference> findDescendants(Reference parent) {
        Node ref = this.findRef(parent);
        if (ref == null) {
            return List.of();
        }
        ArrayList<Reference> children = new ArrayList<Reference>();
        ReferenceTree.visitLeaves(ref, children::add);
        return children;
    }

    public Reference findFirstParentMatching(Reference child, Predicate<Reference> test) {
        Node node = this.root;
        ColumnIdent col = child.column();
        if (!col.name().equals("_doc")) {
            child = DocReferences.toDocLookup(child);
            col = child.column();
        }
        do {
            Node node2;
            Objects.requireNonNull(node);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Leaf.class, Composite.class}, (Node)node2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Leaf l = (Leaf)node2;
                    return test.test(l.ref) ? l.ref : null;
                }
                case 1: 
            }
            Composite c = (Composite)node2;
            if (Objects.equals(c.name, col.name())) {
                if (c.ref != null && test.test(c.ref)) {
                    return c.ref;
                }
                if ((col = col.shiftRight()) == null) {
                    return null;
                }
            } else {
                return null;
            }
            node = c.children.get(col.name());
        } while (node != null);
        return null;
    }

    private static void visitLeaves(Node node, Consumer<Reference> visitor) {
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Composite.class, Leaf.class}, (Node)node3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Composite c = (Composite)node3;
                c.children.forEach((string, v) -> ReferenceTree.visitLeaves(v, visitor));
                break;
            }
            case 1: {
                Leaf l = (Leaf)node3;
                visitor.accept(l.ref);
            }
        }
    }

    private Node findRef(Reference ref) {
        if (Objects.equals("_doc", ref.column().name())) {
            if (ref.column().isRoot()) {
                return this.root;
            }
            return ReferenceTree.findRef(this.root, ref.column().shiftRight());
        }
        return ReferenceTree.findRef(this.root, ref.column());
    }

    private static Node findRef(Node root, ColumnIdent columnIdent) {
        Node node = root;
        Objects.requireNonNull(node);
        Node node2 = node;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Composite.class, Leaf.class}, (Node)node2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Composite c = (Composite)node2;
                Node child = c.children.get(columnIdent.name());
                if (child == null) {
                    return null;
                }
                return columnIdent.isRoot() ? child : ReferenceTree.findRef(child, columnIdent.shiftRight());
            }
            case 1: 
        }
        Leaf l = (Leaf)node2;
        return l;
    }

    public String toString() {
        return this.root.toString();
    }

    private record Composite(String name, Map<String, Node> children, Reference ref) implements Node
    {
    }

    private static sealed interface Node
    permits Composite, Leaf {
        public Reference ref();
    }

    private record Leaf(Reference ref) implements Node
    {
    }
}

