/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.blob;

import io.crate.analyze.WhereClause;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.ShardedTable;
import io.crate.metadata.table.StoredTable;
import io.crate.metadata.table.TableInfo;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class BlobTableInfo
implements TableInfo,
ShardedTable,
StoredTable {
    private final RelationName ident;
    private final int numberOfShards;
    private final String numberOfReplicas;
    private final LinkedHashSet<Reference> columns = new LinkedHashSet();
    private final String blobsPath;
    private final Settings tableParameters;
    private final Version versionCreated;
    private final Version versionUpgraded;
    private final boolean closed;
    private final Map<ColumnIdent, Reference> infos = new LinkedHashMap<ColumnIdent, Reference>();
    private static final List<ColumnIdent> PRIMARY_KEY = List.of(ColumnIdent.of("digest"));

    public BlobTableInfo(RelationName ident, int numberOfShards, String numberOfReplicas, Settings tableParameters, String blobsPath, Version versionCreated, @Nullable Version versionUpgraded, boolean closed) {
        this.ident = ident;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.blobsPath = blobsPath;
        this.tableParameters = tableParameters;
        this.versionCreated = versionCreated;
        this.versionUpgraded = versionUpgraded;
        this.closed = closed;
        this.addColumn("digest", DataTypes.STRING, 0);
        this.addColumn("last_modified", DataTypes.TIMESTAMPZ, 1);
    }

    @Override
    @Nullable
    public Reference getReference(ColumnIdent columnIdent) {
        return this.infos.get(columnIdent);
    }

    @Override
    public Collection<Reference> rootColumns() {
        return this.columns;
    }

    @Override
    public RowGranularity rowGranularity() {
        return RowGranularity.DOC;
    }

    @Override
    public RelationName ident() {
        return this.ident;
    }

    @Override
    public Routing getRouting(ClusterState state, RoutingProvider routingProvider, WhereClause whereClause, RoutingProvider.ShardSelection shardSelection, CoordinatorSessionSettings sessionSettings) {
        String[] indices = state.metadata().getIndices(this.ident, List.of(), true, IndexMetadata::getIndexUUID).toArray(new String[0]);
        return routingProvider.forIndices(state, indices, Set.of(), false, shardSelection);
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return PRIMARY_KEY;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public String numberOfReplicas() {
        return this.numberOfReplicas;
    }

    @Override
    @Nullable
    public ColumnIdent clusteredBy() {
        return PRIMARY_KEY.get(0);
    }

    @Override
    public Iterator<Reference> iterator() {
        return this.columns.iterator();
    }

    private void addColumn(String name, DataType<?> type, int position) {
        SimpleReference ref = new SimpleReference(new ReferenceIdent(this.ident(), name, null), RowGranularity.DOC, type, position, null);
        this.columns.add(ref);
        this.infos.put(ref.column(), ref);
    }

    public String blobsPath() {
        return this.blobsPath;
    }

    @Override
    public Settings parameters() {
        return this.tableParameters;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return Operation.BLOB_OPERATIONS;
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.BASE_TABLE;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String[] concreteIndices(Metadata metadata) {
        return (String[])metadata.getIndices(this.ident, List.of(), true, imd -> imd.getIndex().getUUID()).toArray(String[]::new);
    }

    @Override
    public Version versionCreated() {
        return this.versionCreated;
    }

    @Override
    @Nullable
    public Version versionUpgraded() {
        return this.versionUpgraded;
    }
}

