/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.blob;

import io.crate.blob.v2.BlobIndicesService;
import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.RelationName;
import io.crate.metadata.TableInfoFactory;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.settings.NumberOfReplicas;
import java.nio.file.Path;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class BlobTableInfoFactory
implements TableInfoFactory<BlobTableInfo> {
    private final Path[] dataFiles;
    private final Path globalBlobPath;

    public BlobTableInfoFactory(Environment environment) {
        this.dataFiles = environment.dataFiles();
        this.globalBlobPath = BlobIndicesService.getGlobalBlobPath(environment.settings());
    }

    @Override
    public BlobTableInfo create(RelationName ident, Metadata metadata) {
        RelationMetadata.BlobTable blobTable = (RelationMetadata.BlobTable)metadata.getRelation(ident);
        if (blobTable == null) {
            throw new RelationUnknown(ident);
        }
        String indexUUID = blobTable.indexUUID();
        IndexMetadata indexMetadata = metadata.index(indexUUID);
        if (indexMetadata == null) {
            throw new RelationUnknown(ident);
        }
        Settings tableSettings = blobTable.settings();
        Settings indexSettings = indexMetadata.getSettings();
        return new BlobTableInfo(ident, indexMetadata.getNumberOfShards(), NumberOfReplicas.getVirtualValue(indexSettings), tableSettings, this.blobsPath(tableSettings), indexMetadata.getCreationVersion(), indexSettings.getAsVersion("index.version.upgraded", null), blobTable.state() == IndexMetadata.State.CLOSE);
    }

    private String blobsPath(Settings indexMetadataSettings) {
        String blobsPathStr = BlobIndicesService.SETTING_INDEX_BLOBS_PATH.get(indexMetadataSettings);
        if (Strings.hasLength(blobsPathStr)) {
            return blobsPathStr;
        }
        Path path = this.globalBlobPath;
        if (path == null) {
            return this.dataFiles[0].toString();
        }
        return path.toString();
    }
}

