/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.analyze.TableParameters;
import io.crate.execution.ddl.tables.AlterTableRequest;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.metadata.table.SchemaInfo;
import io.crate.sql.tree.ColumnPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AlterTableClusterStateExecutor
extends DDLClusterStateTaskExecutor<AlterTableRequest> {
    private final IndexScopedSettings indexScopedSettings;
    private final NodeContext nodeContext;
    private final MetadataUpdateSettingsService updateSettingsService;

    public AlterTableClusterStateExecutor(IndexScopedSettings indexScopedSettings, MetadataUpdateSettingsService updateSettingsService, NodeContext nodeContext) {
        this.indexScopedSettings = indexScopedSettings;
        this.nodeContext = nodeContext;
        this.updateSettingsService = updateSettingsService;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, AlterTableRequest request) throws Exception {
        String policy = request.settings().get(TableParameters.COLUMN_POLICY.getKey());
        ColumnPolicy columnPolicy = policy == null ? null : ColumnPolicy.of((String)policy);
        Settings.Builder settingsBuilder = Settings.builder().put(request.settings());
        settingsBuilder.remove(TableParameters.COLUMN_POLICY.getKey());
        Settings settings = settingsBuilder.build();
        Metadata metadata = currentState.metadata();
        Object relation = metadata.getRelation(request.tableIdent());
        if (request.partitionValues().isEmpty() && relation instanceof RelationMetadata.Table) {
            RelationMetadata.Table table = (RelationMetadata.Table)relation;
            Metadata.Builder newMetadata = Metadata.builder(metadata);
            Settings.Builder builder = Settings.builder().put(table.settings()).put(settings);
            for (String setting : settings.keySet()) {
                if (settings.hasValue(setting)) continue;
                builder.remove(setting);
            }
            newMetadata.setTable(table.name(), table.columns(), builder.build(), table.routingColumn(), columnPolicy == null ? table.columnPolicy() : columnPolicy, table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), table.indexUUIDs(), table.tableVersion() + 1L);
            currentState = ClusterState.builder(currentState).metadata(newMetadata).build();
        } else if (!request.partitionValues().isEmpty()) {
            for (Setting setting : TableParameters.TABLE_ONLY_SETTINGS) {
                if (!setting.exists(settings)) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "\"%s\" cannot be changed on partition level", setting.getKey()));
            }
        }
        List<Index> concreteIndices = metadata.getIndices(request.tableIdent(), request.partitionValues(), false, IndexMetadata::getIndex);
        List<PartitionName> partitions = this.partitions(request);
        if (request.isPartitioned()) {
            if (!request.partitionValues().isEmpty()) {
                currentState = this.updateSettings(currentState, settings, partitions);
            } else if (!request.excludePartitions()) {
                ArrayList arrayList = new ArrayList(TableParameters.PARTITIONED_TABLE_PARAMETER_INFO_FOR_TEMPLATE_UPDATE.supportedSettings().values());
                arrayList.add(AutoExpandReplicas.SETTING);
                currentState = this.updateSettings(currentState, AlterTableClusterStateExecutor.filterSettings(settings, arrayList), partitions);
                currentState = this.updateMapping(currentState, concreteIndices, columnPolicy);
            }
        } else {
            currentState = this.updateMapping(currentState, concreteIndices, columnPolicy);
            currentState = this.updateSettings(currentState, settings, partitions);
        }
        RelationName relationName = request.tableIdent();
        SchemaInfo schemaInfo = this.nodeContext.schemas().getOrCreateSchemaInfo(relationName.schema());
        schemaInfo.create(relationName, currentState.metadata());
        return currentState;
    }

    private List<PartitionName> partitions(AlterTableRequest request) {
        if (request.isPartitioned()) {
            return List.of(new PartitionName(request.tableIdent(), request.partitionValues()));
        }
        return List.of(new PartitionName(request.tableIdent(), List.of()));
    }

    private ClusterState updateMapping(ClusterState currentState, List<Index> concreteIndices, @Nullable ColumnPolicy columnPolicy) throws IOException {
        if (columnPolicy == null) {
            return currentState;
        }
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        for (Index index : concreteIndices) {
            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
            Map<String, Object> indexMapping = indexMetadata.mapping().sourceAsMap();
            String mappingValue = columnPolicy.toMappingValue();
            if (indexMapping.get("dynamic").equals(mappingValue)) {
                return currentState;
            }
            indexMapping.put("dynamic", mappingValue);
            IndexMetadata.Builder imBuilder = IndexMetadata.builder(indexMetadata);
            imBuilder.putMapping(new MappingMetadata(indexMapping)).mappingVersion(1L + imBuilder.mappingVersion());
            metadataBuilder.put(imBuilder);
        }
        return ClusterState.builder(currentState).metadata(metadataBuilder).build();
    }

    private ClusterState updateSettings(ClusterState currentState, Settings settings, List<PartitionName> partitions) {
        Settings normalizedSettings = Settings.builder().put(AlterTableClusterStateExecutor.markArchivedSettings(settings)).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        HashSet<String> skippedSettings = new HashSet<String>();
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key.replace("index.", ""));
        }
        Settings closedSettings = settingsForClosedIndices.build();
        Settings openSettings = settingsForOpenIndices.build();
        return this.updateSettingsService.updateState(currentState, partitions, skippedSettings, closedSettings, openSettings);
    }

    @VisibleForTesting
    static Settings filterSettings(Settings settings, List<Setting<?>> settingsFilter) {
        Settings.Builder settingsBuilder = Settings.builder();
        Set<String> settingNames = settings.keySet();
        for (Setting<?> setting : settingsFilter) {
            String key = setting.getKey();
            if (setting.isGroupSetting()) {
                Settings settingsGroup = settings.getByPrefix(key);
                for (String name : settingsGroup.keySet()) {
                    settingsBuilder.put(key + name, settingsGroup.get(name));
                }
                continue;
            }
            if (!settingNames.contains(key)) continue;
            settingsBuilder.put(key, settings.get(key));
        }
        return settingsBuilder.build();
    }

    @VisibleForTesting
    static Settings markArchivedSettings(Settings settings) {
        return Settings.builder().put(settings).putNull("archived.*").build();
    }
}

