/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.common.collections.Lists;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.tables.RenameTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.view.ViewsMetadata;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;

public class RenameTableClusterStateExecutor {
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    private final Logger logger;
    private final DDLClusterStateService ddlClusterStateService;
    private final AllocationService allocationService;

    public RenameTableClusterStateExecutor(AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        this.allocationService = allocationService;
        this.logger = LogManager.getLogger(this.getClass());
        this.ddlClusterStateService = ddlClusterStateService;
    }

    public ClusterState execute(ClusterState currentState, RenameTableRequest request) throws Exception {
        boolean tableExists;
        RelationName source = request.sourceName();
        RelationName target = request.targetName();
        Metadata currentMetadata = currentState.metadata();
        Metadata.Builder newMetadata = Metadata.builder(currentMetadata);
        ViewsMetadata views = (ViewsMetadata)currentMetadata.custom("views");
        boolean isView = views != null && views.contains(source);
        boolean viewExists = views != null && views.contains(target);
        boolean bl = tableExists = currentMetadata.getRelation(target) != null;
        if (viewExists || tableExists) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot rename %s %s to %s, %s %s already exists", isView ? "view" : "table", source, target, viewExists ? "view" : "table", target));
        }
        if (isView) {
            ViewsMetadata updatedViewsMetadata = views.rename(source, target);
            newMetadata.putCustom("views", updatedViewsMetadata);
            return ClusterState.builder(currentState).metadata(newMetadata).build();
        }
        RoutingTable.Builder newRoutingTable = RoutingTable.builder(currentState.routingTable());
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        this.logger.info("renaming table '{}' to '{}'", (Object)source.fqn(), (Object)target.fqn());
        RelationMetadata.Table table = (RelationMetadata.Table)currentMetadata.getRelation(source);
        if (table == null) {
            throw new RelationUnknown(source);
        }
        newMetadata.dropRelation(source).setTable(target, Lists.map(table.columns(), ref -> ref.withReferenceIdent(new ReferenceIdent(target, ref.column()))), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), table.indexUUIDs(), table.tableVersion() + 1L);
        List<IndexMetadata> sourceIndices = currentState.metadata().getIndices(source, List.of(), true, x -> x);
        for (IndexMetadata sourceIndex : sourceIndices) {
            String targetIndexName;
            String sourceIndexUUID = sourceIndex.getIndexUUID();
            if (sourceIndex.partitionValues().isEmpty()) {
                targetIndexName = target.indexNameOrAlias();
            } else {
                PartitionName newPartitionName = new PartitionName(target, sourceIndex.partitionValues());
                targetIndexName = newPartitionName.asIndexName();
            }
            newMetadata.remove(sourceIndexUUID);
            newRoutingTable.remove(sourceIndexUUID);
            blocksBuilder.removeIndexBlocks(sourceIndexUUID);
            IndexMetadata targetMd = IndexMetadata.builder(sourceIndex).indexName(targetIndexName).build();
            newMetadata.put(targetMd, true);
            newRoutingTable.addAsFromCloseToOpen(targetMd);
            blocksBuilder.addBlocks(targetMd);
        }
        ClusterState clusterStateAfterRename = ClusterState.builder(currentState).metadata(newMetadata).routingTable(newRoutingTable.build()).blocks(blocksBuilder).build();
        return this.allocationService.reroute(this.ddlClusterStateService.onRenameTable(clusterStateAfterRename, source, target, request.isPartitioned()), "rename-table");
    }
}

