/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.common.collections.Lists;
import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;

public class SwapAndDropIndexExecutor
extends DDLClusterStateTaskExecutor<SwapAndDropIndexRequest> {
    private final AllocationService allocationService;

    public SwapAndDropIndexExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    public ClusterState execute(ClusterState currentState, SwapAndDropIndexRequest request) throws Exception {
        Metadata metadata = currentState.metadata();
        String resizedIndexUUID = request.source();
        String originalIndexUUID = request.target();
        IndexMetadata resizedIndex = currentState.metadata().index(resizedIndexUUID);
        IndexMetadata originalIndex = currentState.metadata().index(originalIndexUUID);
        if (resizedIndex == null) {
            throw new IllegalArgumentException("Source index must exist: " + resizedIndexUUID);
        }
        if (originalIndex == null) {
            throw new IllegalArgumentException("Target index must exist: " + originalIndexUUID);
        }
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        Metadata.Builder mdBuilder = Metadata.builder(metadata);
        RoutingTable.Builder routingBuilder = RoutingTable.builder(currentState.routingTable());
        IndexRoutingTable index = currentState.routingTable().index(resizedIndex.getIndex());
        if (!index.allPrimaryShardsActive()) {
            throw new UnsupportedOperationException("Cannot swap and drop index if source '" + String.valueOf(resizedIndex.getIndex()) + "' has unallocated primaries");
        }
        mdBuilder.remove(resizedIndex.getIndexUUID());
        mdBuilder.remove(originalIndex.getIndexUUID());
        routingBuilder.remove(resizedIndex.getIndexUUID());
        routingBuilder.remove(originalIndex.getIndexUUID());
        blocksBuilder.removeIndexBlocks(resizedIndex.getIndexUUID());
        blocksBuilder.removeIndexBlocks(originalIndex.getIndexUUID());
        IndexMetadata newIndexMetadata = IndexMetadata.builder(resizedIndex).indexName(originalIndex.getIndex().getName()).build();
        mdBuilder.put(newIndexMetadata, true);
        routingBuilder.addAsFromCloseToOpen(newIndexMetadata);
        blocksBuilder.addBlocks(newIndexMetadata);
        RelationMetadata relation = metadata.getRelation(originalIndexUUID);
        if (relation instanceof RelationMetadata.Table) {
            RelationMetadata.Table table = (RelationMetadata.Table)relation;
            String originalUUID = originalIndex.getIndexUUID();
            List newUUIDs = Lists.map(table.indexUUIDs(), uuid -> uuid.equals(originalUUID) ? newIndexMetadata.getIndexUUID() : uuid);
            mdBuilder.setTable(table.name(), table.columns(), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), newUUIDs, table.tableVersion() + 1L);
        }
        return this.allocationService.reroute(ClusterState.builder(currentState).metadata(mdBuilder).routingTable(routingBuilder.build()).blocks(blocksBuilder).build(), "swap and drop index");
    }
}

