/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import io.crate.blob.v2.BlobIndex;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.metadata.view.ViewInfoFactory;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DocSchemaInfo
implements SchemaInfo {
    public static final String NAME = "doc";
    private final ClusterService clusterService;
    private final DocTableInfoFactory docTableInfoFactory;
    private final ViewInfoFactory viewInfoFactory;
    private final ConcurrentHashMap<String, DocTableInfo> docTableByName = new ConcurrentHashMap();
    public static final Predicate<String> NO_BLOB_NOR_DANGLING = index -> !BlobIndex.isBlobIndex(index) && !IndexName.isDangling(index);
    private final String schemaName;

    public DocSchemaInfo(String schemaName, ClusterService clusterService, ViewInfoFactory viewInfoFactory, DocTableInfoFactory docTableInfoFactory) {
        this.schemaName = schemaName;
        this.clusterService = clusterService;
        this.viewInfoFactory = viewInfoFactory;
        this.docTableInfoFactory = docTableInfoFactory;
    }

    @Override
    public TableInfo getTableInfo(String name) {
        Metadata metadata = this.clusterService.state().metadata();
        DocTableInfo docTableInfo = this.docTableByName.get(name);
        try {
            RelationName relation = new RelationName(this.schemaName, name);
            if (docTableInfo == null) {
                return this.docTableByName.computeIfAbsent(name, n -> this.docTableInfoFactory.create(relation, metadata));
            }
            if (docTableInfo.tableVersion() < DocSchemaInfo.getTableVersion(metadata, relation)) {
                DocTableInfo newTable = this.docTableInfoFactory.create(new RelationName(this.schemaName, name), metadata);
                this.docTableByName.replace(name, newTable);
                return newTable;
            }
            return docTableInfo;
        }
        catch (Exception e) {
            if (e instanceof ResourceUnknownException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public DocTableInfo create(RelationName relationName, Metadata metadata) {
        return this.docTableInfoFactory.create(relationName, metadata);
    }

    private static long getTableVersion(Metadata metadata, RelationName name) {
        RelationMetadata.Table table = (RelationMetadata.Table)metadata.getRelation(name);
        if (table == null) {
            throw new RelationUnknown(name);
        }
        return table.tableVersion();
    }

    private Collection<String> tableNames() {
        List<RelationMetadata.Table> relations = this.clusterService.state().metadata().relations(this.schemaName, RelationMetadata.Table.class);
        return relations.stream().map(r -> r.name().name()).toList();
    }

    @Override
    @Nullable
    public ViewInfo getViewInfo(String name) {
        return this.viewInfoFactory.create(new RelationName(this.schemaName, name), this.clusterService.state());
    }

    private Collection<String> viewNames() {
        ViewsMetadata viewMetadata = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        if (viewMetadata == null) {
            return Collections.emptySet();
        }
        HashSet<String> views = new HashSet<String>();
        DocSchemaInfo.extractRelationNamesForSchema(StreamSupport.stream(viewMetadata.names().spliterator(), false), this.schemaName, views);
        return views;
    }

    private static void extractRelationNamesForSchema(Stream<String> stream, String schema, Set<String> target) {
        stream.filter(NO_BLOB_NOR_DANGLING).map(IndexName::decode).filter(indexParts -> !indexParts.isPartitioned()).filter(indexParts -> indexParts.schema().equals(schema)).map(IndexParts::table).forEach(target::add);
    }

    @Override
    public String name() {
        return this.schemaName;
    }

    @Override
    public void update(ClusterChangedEvent event) {
        assert (event.metadataChanged()) : "metadataChanged must be true if update is called";
        Metadata prevMetadata = event.previousState().metadata();
        Metadata newMetadata = event.state().metadata();
        for (String tableName : this.docTableByName.keySet()) {
            Object newRelationMetadata = newMetadata.getRelation(new RelationName(this.schemaName, tableName));
            if (newRelationMetadata == null) {
                this.docTableByName.remove(tableName);
                continue;
            }
            Object oldRelationMetadata = prevMetadata.getRelation(new RelationName(this.schemaName, tableName));
            if (newRelationMetadata.equals(oldRelationMetadata)) continue;
            this.docTableByName.remove(tableName);
        }
        PublicationsMetadata prevPublicationsMetadata = (PublicationsMetadata)prevMetadata.custom("publications");
        PublicationsMetadata newPublicationsMetadata = (PublicationsMetadata)newMetadata.custom("publications");
        Set<String> tablesAffectedByPublicationsChange = DocSchemaInfo.getTablesAffectedByPublicationsChange(prevPublicationsMetadata, newPublicationsMetadata, this.docTableByName);
        for (String updatedTable : tablesAffectedByPublicationsChange) {
            this.docTableByName.remove(updatedTable);
        }
    }

    @VisibleForTesting
    static Set<String> getTablesAffectedByPublicationsChange(@Nullable PublicationsMetadata prevMetadata, @Nullable PublicationsMetadata newMetadata, Map<String, DocTableInfo> docTableByName) {
        Set<String> result;
        if (Objects.equals(prevMetadata, newMetadata)) {
            return Set.of();
        }
        if (prevMetadata == null) {
            HashSet<String> result2 = new HashSet<String>();
            for (Publication publication : newMetadata.publications().values()) {
                if (publication.isForAllTables()) {
                    return docTableByName.keySet();
                }
                for (RelationName table : publication.tables()) {
                    result2.add(table.name());
                }
            }
            return result2;
        }
        HashSet<String> prevPublishedTables = new HashSet<String>();
        HashSet<String> newPublishedTables = new HashSet<String>();
        boolean allPrevTablesArePublished = false;
        boolean allNewTablesArePublished = false;
        for (Publication publication : prevMetadata.publications().values()) {
            if (publication.isForAllTables()) {
                allPrevTablesArePublished = true;
                continue;
            }
            for (RelationName table : publication.tables()) {
                prevPublishedTables.add(table.name());
            }
        }
        for (Publication publication : newMetadata.publications().values()) {
            if (publication.isForAllTables()) {
                allNewTablesArePublished = true;
                continue;
            }
            for (RelationName table : publication.tables()) {
                newPublishedTables.add(table.name());
            }
        }
        if (allPrevTablesArePublished && allNewTablesArePublished) {
            return Set.of();
        }
        if (allPrevTablesArePublished && !allNewTablesArePublished) {
            result = docTableByName.keySet();
            result.removeAll(newPublishedTables);
            return result;
        }
        if (!allPrevTablesArePublished && allNewTablesArePublished) {
            result = docTableByName.keySet();
            result.removeAll(prevPublishedTables);
            return result;
        }
        result = new HashSet<String>();
        ((AbstractCollection)((Object)result)).addAll(prevPublishedTables);
        ((AbstractCollection)((Object)result)).addAll(newPublishedTables);
        HashSet intersection = new HashSet(prevPublishedTables);
        intersection.retainAll(newPublishedTables);
        ((AbstractSet)result).removeAll(intersection);
        return result;
    }

    @VisibleForTesting
    void invalidateFromIndex(Index index, Metadata metadata) {
        IndexMetadata indexMetadata = metadata.index(index);
        if (indexMetadata != null) {
            this.invalidateAliases(indexMetadata.getAliases());
        }
    }

    private void invalidateAliases(ImmutableOpenMap<String, AliasMetadata> aliases) {
        assert (aliases != null) : "aliases must not be null";
        if (aliases.size() > 0) {
            aliases.keysIt().forEachRemaining(this.docTableByName::remove);
        }
    }

    public String toString() {
        return "DocSchemaInfo(" + this.name() + ")";
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return this.tableNames().stream().map(this::getTableInfo).filter(Objects::nonNull)::iterator;
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return this.viewNames().stream().map(this::getViewInfo).filter(Objects::nonNull)::iterator;
    }

    @Override
    public void close() throws Exception {
    }
}

