/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.TableReferenceResolver;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.Booleans;
import io.crate.common.collections.Maps;
import io.crate.exceptions.RelationUnknown;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexReference;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.TableInfoFactory;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.table.Operation;
import io.crate.metadata.upgrade.IndexTemplateUpgrader;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.BitStringType;
import io.crate.types.CharacterType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FloatVectorType;
import io.crate.types.NumericType;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import io.crate.types.StringType;
import io.crate.types.UndefinedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class DocTableInfoFactory
implements TableInfoFactory<DocTableInfo> {
    private final NodeContext nodeCtx;
    private final ExpressionAnalyzer expressionAnalyzer;
    private final CoordinatorTxnCtx systemTransactionContext;

    public DocTableInfoFactory(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
        this.systemTransactionContext = CoordinatorTxnCtx.systemTransactionContext();
        this.expressionAnalyzer = new ExpressionAnalyzer(this.systemTransactionContext, nodeCtx, ParamTypeHints.EMPTY, FieldProvider.UNSUPPORTED, null);
    }

    @Override
    public DocTableInfo create(RelationName relation, Metadata metadata) {
        Object relationMetadata = metadata.getRelation(relation);
        if (relationMetadata == null) {
            throw new RelationUnknown(relation);
        }
        if (relationMetadata instanceof RelationMetadata.Table) {
            RelationMetadata.Table table = (RelationMetadata.Table)relationMetadata;
            return this.tableFromRelationMetadata(table, metadata);
        }
        throw new UnsupportedOperationException("Unsupported relation type: " + relationMetadata.getClass().getSimpleName());
    }

    private DocTableInfo tableFromRelationMetadata(RelationMetadata.Table table, Metadata metadata) {
        PublicationsMetadata publicationsMetadata = (PublicationsMetadata)metadata.custom("publications");
        Map<ColumnIdent, Reference> columns = table.columns().stream().filter(ref -> !ref.isDropped()).filter(ref -> {
            IndexReference indexRef;
            return !(ref instanceof IndexReference && !(indexRef = (IndexReference)ref).columns().isEmpty());
        }).collect(Collectors.toMap(Reference::column, ref -> ref));
        Map<ColumnIdent, IndexReference> indexColumns = table.columns().stream().filter(ref -> {
            IndexReference indexRef;
            return ref instanceof IndexReference && !(indexRef = (IndexReference)ref).columns().isEmpty();
        }).map(ref -> (IndexReference)ref).collect(Collectors.toMap(SimpleReference::column, ref -> ref));
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(this.systemTransactionContext, this.nodeCtx, ParamTypeHints.EMPTY, new TableReferenceResolver(columns, table.name()), null);
        ExpressionAnalysisContext expressionAnalysisContext = new ExpressionAnalysisContext(this.systemTransactionContext.sessionSettings());
        Version versionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(table.settings());
        Version versionUpgraded = table.settings().getAsVersion("index.version.upgraded", null);
        ColumnIdent routingColumn = table.routingColumn();
        if (routingColumn == null) {
            routingColumn = table.primaryKeys().size() == 1 ? table.primaryKeys().get(0) : SysColumns.ID.COLUMN;
        }
        List<CheckConstraint<Symbol>> checkConstraints = DocTableInfoFactory.getCheckConstraints(expressionAnalyzer, expressionAnalysisContext, table.checkConstraints());
        return new DocTableInfo(table.name(), columns, indexColumns, table.columns().stream().filter(Reference::isDropped).collect(Collectors.toSet()), table.pkConstraintName(), table.primaryKeys(), checkConstraints, routingColumn, table.settings(), table.partitionedBy(), table.columnPolicy(), versionCreated, versionUpgraded, table.state() == IndexMetadata.State.CLOSE, Operation.buildFromIndexSettingsAndState(table.settings(), table.state(), publicationsMetadata == null ? false : publicationsMetadata.isPublished(table.name())), table.tableVersion());
    }

    @Deprecated
    @Nullable
    public DocTableInfo create(IndexMetadata indexMetadata) {
        String indexName = indexMetadata.getIndex().getName();
        if (IndexName.isDangling(indexName)) {
            return null;
        }
        RelationName relationName = RelationName.fromIndexName(indexName);
        Settings tableParameters = indexMetadata.getSettings();
        Version versionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(tableParameters);
        Version versionUpgraded = tableParameters.getAsVersion("index.version.upgraded", null);
        MappingMetadata mapping = indexMetadata.mapping();
        Map<String, Object> mappingSource = mapping == null ? Map.of() : mapping.sourceAsMap();
        return this.create(relationName, mappingSource, tableParameters, versionCreated, versionUpgraded, indexMetadata.getState(), indexMetadata.getVersion(), false);
    }

    @Deprecated
    public DocTableInfo create(IndexTemplateMetadata template, Metadata metadata) {
        RelationName relationName = RelationName.fromIndexName(template.name());
        Map mappingSource = IndexTemplateUpgrader.updateMapping(template.mapping());
        mappingSource = (Map)Maps.getOrDefault(mappingSource, (String)"default", mappingSource);
        Settings tableParameters = template.settings();
        Version versionUpgraded = null;
        boolean isClosed = (Boolean)Maps.getOrDefault((Map)((Map)Maps.getOrDefault((Map)mappingSource, (String)"_meta", Map.of())), (String)"closed", (Object)false);
        IndexMetadata.State state = isClosed ? IndexMetadata.State.CLOSE : IndexMetadata.State.OPEN;
        Integer tableVersion = template.version();
        return this.create(relationName, mappingSource, tableParameters, tableParameters.getAsVersion("index.version.created", Version.CURRENT), versionUpgraded, state, tableVersion == null ? 0L : tableVersion.longValue(), true);
    }

    private DocTableInfo create(RelationName relationName, Map<String, Object> mappingSource, Settings tableParameters, Version versionCreated, Version versionUpgraded, IndexMetadata.State state, long tableVersion, boolean fromTemplate) {
        Map metaMap = (Map)Maps.getOrDefault(mappingSource, (String)"_meta", Map.of());
        List<ColumnIdent> partitionedBy = DocTableInfoFactory.parsePartitionedByStringsList((List)Maps.getOrDefault((Map)metaMap, (String)"partitioned_by", List.of()));
        List<ColumnIdent> primaryKeys = DocTableInfoFactory.getPrimaryKeys(metaMap);
        Set<ColumnIdent> notNullColumns = DocTableInfoFactory.getNotNullColumns(metaMap);
        Map indicesMap = (Map)Maps.getOrDefault((Map)metaMap, (String)"indices", Map.of());
        Map properties = (Map)Maps.getOrDefault(mappingSource, (String)"properties", Map.of());
        HashMap<ColumnIdent, Reference> references = new HashMap<ColumnIdent, Reference>();
        HashSet<Reference> droppedColumns = new HashSet<Reference>();
        HashMap<ColumnIdent, IndexReference.Builder> indexColumns = new HashMap<ColumnIdent, IndexReference.Builder>();
        DocTableInfoFactory.parseColumns(this.expressionAnalyzer, relationName, null, indicesMap, notNullColumns, primaryKeys, partitionedBy, properties, indexColumns, references, droppedColumns);
        ExpressionAnalyzer refExpressionAnalyzer = new ExpressionAnalyzer(this.systemTransactionContext, this.nodeCtx, ParamTypeHints.EMPTY, new TableReferenceResolver(references, relationName), null);
        ExpressionAnalysisContext expressionAnalysisContext = new ExpressionAnalysisContext(this.systemTransactionContext.sessionSettings());
        Map generatedColumns = (Map)Maps.getOrDefault((Map)metaMap, (String)"generated_columns", Map.of());
        for (Map.Entry entry : generatedColumns.entrySet()) {
            ColumnIdent column = ColumnIdent.fromPath((String)entry.getKey());
            String generatedExpressionStr = (String)entry.getValue();
            Reference reference = (Reference)references.get(column);
            Symbol generatedExpression = refExpressionAnalyzer.convert(SqlParser.createExpression((String)generatedExpressionStr), expressionAnalysisContext).cast(reference.valueType(), new CastMode[0]);
            GeneratedReference generatedRef = new GeneratedReference(reference, generatedExpression);
            references.put(column, generatedRef);
        }
        List<CheckConstraint<Symbol>> checkConstraints = DocTableInfoFactory.getCheckConstraints(refExpressionAnalyzer, expressionAnalysisContext, (Map)Maps.get((Map)metaMap, (String)"check_constraints"));
        ColumnIdent clusteredBy = DocTableInfoFactory.getClusteredBy(primaryKeys, (String)Maps.get((Map)metaMap, (String)"routing"));
        if (fromTemplate && versionCreated.onOrAfter(DocTableInfo.COLUMN_OID_VERSION) && references.values().stream().anyMatch(ref -> ref.oid() == 0L)) {
            versionCreated = Version.V_5_4_0;
        }
        return new DocTableInfo(relationName, references, indexColumns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexReference.Builder)e.getValue()).build(references))), droppedColumns, (String)Maps.get((Map)metaMap, (String)"pk_constraint_name"), primaryKeys, checkConstraints, clusteredBy, tableParameters, partitionedBy, ColumnPolicy.fromMappingValue((Object)mappingSource.get("dynamic")), versionCreated, versionUpgraded, state == IndexMetadata.State.CLOSE, Operation.CLOSED_OPERATIONS, tableVersion);
    }

    private static ColumnIdent getClusteredBy(List<ColumnIdent> primaryKeys, @Nullable String routing) {
        if (routing != null) {
            return ColumnIdent.fromPath(routing);
        }
        if (primaryKeys.size() == 1) {
            return primaryKeys.get(0);
        }
        return SysColumns.ID.COLUMN;
    }

    private static List<CheckConstraint<Symbol>> getCheckConstraints(ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext, @Nullable Map<String, String> checkConstraints) {
        if (checkConstraints == null) {
            return List.of();
        }
        ArrayList<CheckConstraint<Symbol>> result = new ArrayList<CheckConstraint<Symbol>>(checkConstraints.size());
        for (Map.Entry<String, String> entry : checkConstraints.entrySet()) {
            String name = entry.getKey();
            String expressionStr = entry.getValue();
            Symbol expression = expressionAnalyzer.convert(SqlParser.createExpression((String)expressionStr), expressionAnalysisContext);
            CheckConstraint checkConstraint = new CheckConstraint(name, (Object)expression, expressionStr);
            result.add((CheckConstraint<Symbol>)checkConstraint);
        }
        return result;
    }

    public static void parseColumns(ExpressionAnalyzer expressionAnalyzer, RelationName relationName, @Nullable ColumnIdent parent, Map<String, Object> indicesMap, Set<ColumnIdent> notNullColumns, List<ColumnIdent> primaryKeys, List<ColumnIdent> partitionedBy, Map<String, Object> properties, Map<ColumnIdent, IndexReference.Builder> indexColumns, Map<ColumnIdent, Reference> references, Set<Reference> droppedColumns) {
        CoordinatorTxnCtx txnCtx = CoordinatorTxnCtx.systemTransactionContext();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String indicesKey;
            boolean nullable;
            boolean isPartitionColumn;
            String columnName = entry.getKey();
            Map<String, Object> columnProperties = (Map<String, Object>)entry.getValue();
            DataType<?> type = DocTableInfoFactory.getColumnDataType(columnProperties);
            ColumnIdent column = parent == null ? ColumnIdent.of(columnName) : parent.getChild(columnName);
            ReferenceIdent refIdent = new ReferenceIdent(relationName, column);
            columnProperties = DocTableInfoFactory.innerProperties(columnProperties);
            String analyzer = (String)columnProperties.get("analyzer");
            String defaultExpressionString = (String)Maps.get(columnProperties, (String)"default_expr");
            Symbol defaultExpression = null;
            if (defaultExpressionString != null) {
                defaultExpression = expressionAnalyzer.convert(SqlParser.createExpression((String)defaultExpressionString), new ExpressionAnalysisContext(txnCtx.sessionSettings()));
            }
            IndexType indexType = (isPartitionColumn = partitionedBy.contains(column)) ? IndexType.PLAIN : DocTableInfoFactory.getColumnIndexType(columnProperties);
            RowGranularity granularity = isPartitionColumn ? RowGranularity.PARTITION : RowGranularity.DOC;
            StorageSupport<?> storageSupport = type.storageSupportSafe();
            boolean docValuesDefault = storageSupport.getComputedDocValuesDefault(indexType);
            Object docValues = columnProperties.get("doc_values");
            boolean hasDocValues = docValues == null ? docValuesDefault : Booleans.parseBoolean((String)docValues.toString());
            int position = (Integer)Maps.getOrDefault(columnProperties, (String)"position", (Object)0);
            Number oidNum = (Number)Maps.getOrDefault(columnProperties, (String)"oid", (Object)0L);
            long oid = oidNum.longValue();
            DataType<?> elementType = ArrayType.unnest(type);
            boolean isDropped = (Boolean)Maps.getOrDefault(columnProperties, (String)"dropped", (Object)false);
            boolean bl = nullable = !notNullColumns.contains(column) && !primaryKeys.contains(column);
            if (elementType.equals(DataTypes.GEO_SHAPE)) {
                String geoTree = (String)columnProperties.get("tree");
                String precision = (String)columnProperties.get("precision");
                Integer treeLevels = (Integer)columnProperties.get("tree_levels");
                Double distanceErrorPct = (Double)columnProperties.get("distance_error_pct");
                GeoReference ref = new GeoReference(refIdent, type, IndexType.PLAIN, nullable, position, oid, isDropped, defaultExpression, geoTree, precision, treeLevels, distanceErrorPct);
                if (isDropped) {
                    droppedColumns.add(ref);
                    continue;
                }
                references.put(column, ref);
                continue;
            }
            if (elementType.id() == 12) {
                Map nestedProperties;
                SimpleReference ref = new SimpleReference(refIdent, granularity, type, indexType, nullable, hasDocValues, position, oid, isDropped, defaultExpression);
                if (isDropped) {
                    droppedColumns.add(ref);
                } else {
                    references.put(column, ref);
                }
                if ((nestedProperties = (Map)Maps.get(columnProperties, (String)"properties")) == null) continue;
                DocTableInfoFactory.parseColumns(expressionAnalyzer, relationName, column, indicesMap, notNullColumns, primaryKeys, partitionedBy, nestedProperties, indexColumns, references, droppedColumns);
                continue;
            }
            if (type == DataTypes.NOT_SUPPORTED) continue;
            String string = indicesKey = oid == 0L ? column.fqn() : Long.toString(oid);
            if (indicesMap.containsKey(indicesKey)) {
                List sources = (List)Maps.get(columnProperties, (String)"sources");
                if (sources == null) continue;
                IndexReference.Builder builder = indexColumns.computeIfAbsent(column, k -> new IndexReference.Builder(refIdent));
                builder.indexType(indexType).position(position).oid(oid).analyzer(analyzer).sources(sources);
                continue;
            }
            SimpleReference ref = analyzer == null ? new SimpleReference(refIdent, granularity, type, indexType, nullable, hasDocValues, position, oid, isDropped, defaultExpression) : new IndexReference(refIdent, granularity, type, indexType, nullable, hasDocValues, position, oid, isDropped, defaultExpression, List.of(), analyzer);
            if (isDropped) {
                droppedColumns.add(ref);
                continue;
            }
            references.put(column, ref);
        }
    }

    private static IndexType getColumnIndexType(Map<String, Object> columnProperties) {
        Object index = columnProperties.get("index");
        if (index == null) {
            if ("text".equals(columnProperties.get("type"))) {
                return IndexType.FULLTEXT;
            }
            return IndexType.PLAIN;
        }
        if (Boolean.FALSE.equals(index) || "no".equals(index) || "false".equals(index)) {
            return IndexType.NONE;
        }
        if ("not_analyzed".equals(index)) {
            return IndexType.PLAIN;
        }
        return IndexType.FULLTEXT;
    }

    private static Map<String, Object> innerProperties(Map<String, Object> columnProperties) {
        Map inner;
        Map next = inner = columnProperties;
        while (next != null) {
            inner = next;
            next = (Map)Maps.get(inner, (String)"inner");
        }
        return inner;
    }

    private static List<ColumnIdent> getPrimaryKeys(Map<String, Object> metaMap) {
        Object primaryKeys = metaMap.get("primary_keys");
        if (primaryKeys == null) {
            return List.of();
        }
        if (primaryKeys instanceof String) {
            String pkString = (String)primaryKeys;
            return List.of(ColumnIdent.fromPath(pkString));
        }
        if (primaryKeys instanceof Collection) {
            Collection keys = (Collection)primaryKeys;
            ArrayList<ColumnIdent> result = new ArrayList<ColumnIdent>(keys.size());
            for (Object key : keys) {
                result.add(ColumnIdent.fromPath(key.toString()));
            }
            return result;
        }
        return List.of();
    }

    private static Set<ColumnIdent> getNotNullColumns(Map<String, Object> metaMap) {
        Map constraintsMap = (Map)Maps.get(metaMap, (String)"constraints");
        if (constraintsMap == null) {
            return Set.of();
        }
        HashSet<ColumnIdent> result = new HashSet<ColumnIdent>();
        Collection notNullCols = (Collection)Maps.getOrDefault((Map)constraintsMap, (String)"not_null", List.of());
        for (Object notNullColumn : notNullCols) {
            result.add(ColumnIdent.fromPath(notNullColumn.toString()));
        }
        return result;
    }

    private static List<ColumnIdent> parsePartitionedByStringsList(List<List<String>> partitionedByList) {
        ArrayList<ColumnIdent> builder = new ArrayList<ColumnIdent>();
        for (List<String> partitionedByInfo : partitionedByList) {
            builder.add(ColumnIdent.fromPath(partitionedByInfo.get(0)));
        }
        return List.copyOf(builder);
    }

    public static DataType<?> getColumnDataType(Map<String, Object> columnProperties) {
        String typeName = (String)columnProperties.get("type");
        if (typeName == null || "object".equals(typeName)) {
            Map innerProperties = columnProperties.getOrDefault("properties", Map.of());
            ArrayList<InnerObjectType> children = new ArrayList<InnerObjectType>();
            for (Map.Entry entry : innerProperties.entrySet()) {
                Map value = (Map)entry.getValue();
                boolean isDropped = (Boolean)Maps.getOrDefault((Map)value, (String)"dropped", (Object)false);
                if (isDropped) continue;
                int position = value.getOrDefault("position", -1);
                children.add(new InnerObjectType((String)entry.getKey(), position, DocTableInfoFactory.getColumnDataType(value)));
            }
            children.sort(Comparator.comparingInt(InnerObjectType::position));
            ColumnPolicy columnPolicy = ColumnPolicy.fromMappingValue((Object)columnProperties.get("dynamic"));
            ObjectType.Builder builder = ObjectType.of(columnPolicy, children.size());
            for (InnerObjectType child : children) {
                builder.setInnerType(child.name, child.type);
            }
            return builder.build();
        }
        if (typeName.equalsIgnoreCase("array")) {
            Map innerProperties = (Map)Maps.get(columnProperties, (String)"inner");
            if (Objects.equals(UndefinedType.INSTANCE.getName(), innerProperties.get("type"))) {
                return new ArrayType<Object>(UndefinedType.INSTANCE);
            }
            DataType<?> innerType = DocTableInfoFactory.getColumnDataType(innerProperties);
            return new ArrayType(innerType);
        }
        return switch (typeName.toLowerCase(Locale.ENGLISH)) {
            case "date" -> {
                Boolean ignoreTimezone = (Boolean)columnProperties.get("ignore_timezone");
                if (ignoreTimezone != null && ignoreTimezone.booleanValue()) {
                    yield DataTypes.TIMESTAMP;
                }
                yield DataTypes.TIMESTAMPZ;
            }
            case "keyword" -> {
                Integer lengthLimit = (Integer)columnProperties.get("length_limit");
                Object blankPadding = columnProperties.get("blank_padding");
                if (blankPadding != null && ((Boolean)blankPadding).booleanValue()) {
                    yield CharacterType.of(lengthLimit);
                }
                if (lengthLimit != null) {
                    yield StringType.of(lengthLimit);
                }
                yield DataTypes.STRING;
            }
            case "bit" -> {
                Integer length = (Integer)columnProperties.get("length");
                if (!$assertionsDisabled && length == null) {
                    throw new AssertionError((Object)"Length is required for bit string type");
                }
                yield new BitStringType(length);
            }
            case "numeric" -> {
                Integer precision = (Integer)columnProperties.get("precision");
                Integer scale = (Integer)columnProperties.get("scale");
                yield new NumericType(precision, scale);
            }
            case "float_vector" -> {
                Integer dimensions = (Integer)columnProperties.get("dimensions");
                yield new FloatVectorType(dimensions);
            }
            default -> Objects.requireNonNullElse(DataTypes.ofMappingName(typeName), DataTypes.NOT_SUPPORTED);
        };
    }

    public static final class MappingKeys {
        public static final String DOC_VALUES = "doc_values";
        public static final String DATE = "date";
        public static final String KEYWORD = "keyword";
        public static final String BITSTRING = "bit";

        private MappingKeys() {
        }
    }

    record InnerObjectType(String name, int position, DataType<?> type) {
    }
}

