/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.information;

import io.crate.execution.engine.collect.files.SqlFeatureContext;
import io.crate.execution.engine.collect.sources.InformationSchemaIterables;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.information.ColumnContext;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ServersMetadata;
import io.crate.metadata.PartitionInfo;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.RoutineInfo;
import io.crate.metadata.information.ForeignServerOptionsTableInfo;
import io.crate.metadata.information.ForeignServerTableInfo;
import io.crate.metadata.information.ForeignTableOptionsTableInfo;
import io.crate.metadata.information.ForeignTableTableInfo;
import io.crate.metadata.information.InformationAdministrableRoleAuthorizationsTableInfo;
import io.crate.metadata.information.InformationApplicableRolesTableInfo;
import io.crate.metadata.information.InformationCharacterSetsTable;
import io.crate.metadata.information.InformationColumnsTableInfo;
import io.crate.metadata.information.InformationEnabledRolesTableInfo;
import io.crate.metadata.information.InformationKeyColumnUsageTableInfo;
import io.crate.metadata.information.InformationPartitionsTableInfo;
import io.crate.metadata.information.InformationReferentialConstraintsTableInfo;
import io.crate.metadata.information.InformationRoleTableGrantsTableInfo;
import io.crate.metadata.information.InformationRoutinesTableInfo;
import io.crate.metadata.information.InformationSchemataTableInfo;
import io.crate.metadata.information.InformationSqlFeaturesTableInfo;
import io.crate.metadata.information.InformationTableConstraintsTableInfo;
import io.crate.metadata.information.InformationTablesTableInfo;
import io.crate.metadata.information.InformationViewsTableInfo;
import io.crate.metadata.information.UserMappingOptionsTableInfo;
import io.crate.metadata.information.UserMappingsTableInfo;
import io.crate.metadata.table.ConstraintInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.StreamSupport;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class InformationSchemaTableDefinitions {
    private final Map<RelationName, StaticTableDefinition<?>> tableDefinitions;

    @Inject
    public InformationSchemaTableDefinitions(Roles roles, InformationSchemaIterables informationSchemaIterables) {
        Map.Entry[] entryArray = new Map.Entry[21];
        entryArray[0] = Map.entry(InformationSchemataTableInfo.IDENT, new StaticTableDefinition<SchemaInfo>(informationSchemaIterables::schemas, (user, s) -> roles.hasAnyPrivilege((Role)user, Securable.SCHEMA, s.name()), InformationSchemataTableInfo.INSTANCE.expressions()));
        entryArray[1] = Map.entry(InformationTablesTableInfo.IDENT, new StaticTableDefinition<RelationInfo>(informationSchemaIterables::relations, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.ident().fqn()) || roles.hasAnyPrivilege((Role)user, Securable.VIEW, t.ident().fqn()), InformationTablesTableInfo.INSTANCE.expressions()));
        entryArray[2] = Map.entry(InformationViewsTableInfo.IDENT, new StaticTableDefinition<ViewInfo>(informationSchemaIterables::views, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.VIEW, t.ident().fqn()), InformationViewsTableInfo.INSTANCE.expressions()));
        entryArray[3] = Map.entry(InformationPartitionsTableInfo.IDENT, new StaticTableDefinition<PartitionInfo>(informationSchemaIterables::partitions, (user, p) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, p.name().relationName().fqn()), InformationPartitionsTableInfo.INSTANCE.expressions()));
        entryArray[4] = Map.entry(InformationColumnsTableInfo.IDENT, new StaticTableDefinition<ColumnContext>(informationSchemaIterables::columns, (user, c) -> (roles.hasAnyPrivilege((Role)user, Securable.TABLE, c.relation().ident().fqn()) || roles.hasAnyPrivilege((Role)user, Securable.VIEW, c.relation().ident().fqn())) && !c.ref().isDropped(), InformationColumnsTableInfo.INSTANCE.expressions()));
        entryArray[5] = Map.entry(InformationTableConstraintsTableInfo.IDENT, new StaticTableDefinition<ConstraintInfo>(informationSchemaIterables::constraints, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.relationName().fqn()), InformationTableConstraintsTableInfo.INSTANCE.expressions()));
        entryArray[6] = Map.entry(InformationRoutinesTableInfo.IDENT, new StaticTableDefinition<RoutineInfo>(informationSchemaIterables::routines, (user, r) -> roles.hasAnyPrivilege((Role)user, Securable.SCHEMA, r.schema()), InformationRoutinesTableInfo.INSTANCE.expressions()));
        entryArray[7] = Map.entry(InformationSqlFeaturesTableInfo.IDENT, new StaticTableDefinition<SqlFeatureContext>((transactionContext, role) -> CompletableFuture.completedFuture(informationSchemaIterables.features()), InformationSqlFeaturesTableInfo.INSTANCE.expressions(), false));
        entryArray[8] = Map.entry(InformationKeyColumnUsageTableInfo.IDENT, new StaticTableDefinition<InformationSchemaIterables.KeyColumnUsage>(informationSchemaIterables::keyColumnUsage, (user, k) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, k.getFQN()), InformationKeyColumnUsageTableInfo.INSTANCE.expressions()));
        entryArray[9] = Map.entry(InformationReferentialConstraintsTableInfo.IDENT, new StaticTableDefinition<Void>((transactionContext, role) -> CompletableFuture.completedFuture(informationSchemaIterables.referentialConstraintsInfos()), InformationReferentialConstraintsTableInfo.INSTANCE.expressions(), false));
        entryArray[10] = Map.entry(InformationCharacterSetsTable.IDENT, new StaticTableDefinition<Void>((transactionContext, role) -> CompletableFuture.completedFuture(Arrays.asList(new Void[]{null})), InformationCharacterSetsTable.INSTANCE.expressions(), false));
        entryArray[11] = Map.entry(InformationEnabledRolesTableInfo.IDENT, new StaticTableDefinition<String>((transactionContext, role) -> CompletableFuture.completedFuture(informationSchemaIterables.enabledRoles(role, roles)), InformationEnabledRolesTableInfo.INSTANCE.expressions(), false));
        entryArray[12] = Map.entry(InformationApplicableRolesTableInfo.IDENT, new StaticTableDefinition<InformationSchemaIterables.ApplicableRole>((transactionContext, role) -> CompletableFuture.completedFuture(informationSchemaIterables.applicableRoles(role, roles)), InformationApplicableRolesTableInfo.INSTANCE.expressions(), false));
        entryArray[13] = Map.entry(InformationRoleTableGrantsTableInfo.IDENT, new StaticTableDefinition<InformationSchemaIterables.RoleTableGrant>((transactionContext, role) -> CompletableFuture.completedFuture(informationSchemaIterables.roleTableGrants(role, roles)), InformationRoleTableGrantsTableInfo.INSTANCE.expressions(), false));
        entryArray[14] = Map.entry(InformationAdministrableRoleAuthorizationsTableInfo.IDENT, new StaticTableDefinition<InformationSchemaIterables.ApplicableRole>((transactionContext, role) -> CompletableFuture.completedFuture(informationSchemaIterables.administrableRoleAuthorizations(role, roles)), InformationAdministrableRoleAuthorizationsTableInfo.INSTANCE.expressions(), false));
        entryArray[15] = Map.entry(ForeignServerTableInfo.IDENT, new StaticTableDefinition<ServersMetadata.Server>(informationSchemaIterables::servers, (user, t) -> user.isSuperUser() || t.owner().equals(user.name()), ForeignServerTableInfo.INSTANCE.expressions()));
        entryArray[16] = Map.entry(ForeignServerOptionsTableInfo.IDENT, new StaticTableDefinition<ServersMetadata.Server.Option>(informationSchemaIterables::serverOptions, (user, t) -> user.isSuperUser() || t.serverOwner().equals(user.name()), ForeignServerOptionsTableInfo.INSTANCE.expressions()));
        entryArray[17] = Map.entry(ForeignTableTableInfo.IDENT, new StaticTableDefinition<ForeignTable>(informationSchemaIterables::foreignTables, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.name().fqn()), ForeignTableTableInfo.INSTANCE.expressions()));
        entryArray[18] = Map.entry(ForeignTableOptionsTableInfo.IDENT, new StaticTableDefinition<ForeignTable.Option>(informationSchemaIterables::foreignTableOptions, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.relationName().fqn()), ForeignTableOptionsTableInfo.INSTANCE.expressions()));
        entryArray[19] = Map.entry(UserMappingsTableInfo.IDENT, new StaticTableDefinition<UserMappingsTableInfo.UserMapping>(informationSchemaIterables::userMappings, (user, userMapping) -> roles.hasALPrivileges((Role)user), UserMappingsTableInfo.INSTANCE.expressions()));
        entryArray[20] = Map.entry(UserMappingOptionsTableInfo.IDENT, new StaticTableDefinition<UserMappingOptionsTableInfo.UserMappingOptions>((transactionContext, user) -> CompletableFuture.completedFuture(() -> StreamSupport.stream(informationSchemaIterables.userMappingOptions().spliterator(), false).filter(userMappingOptions -> roles.hasALPrivileges(user)).map(userMappingOptions -> {
            if (!(user.name().equals(userMappingOptions.userName()) || user.isSuperUser())) {
                return new UserMappingOptionsTableInfo.UserMappingOptions(userMappingOptions.userName(), userMappingOptions.serverName(), userMappingOptions.optionName(), null);
            }
            return userMappingOptions;
        }).iterator()), UserMappingOptionsTableInfo.INSTANCE.expressions(), true));
        this.tableDefinitions = Map.ofEntries(entryArray);
    }

    public StaticTableDefinition<?> get(RelationName relationName) {
        return this.tableDefinitions.get(relationName);
    }
}

