/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.common.collections.Lists;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionName;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.functions.Signature;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.types.TypeSignature;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.lucene.util.StringHelper;
import org.jetbrains.annotations.VisibleForTesting;

public final class OidHash {
    private OidHash() {
    }

    private static int oid(String key) {
        byte[] b = key.getBytes(StandardCharsets.UTF_8);
        return StringHelper.murmurhash3_x86_32((byte[])b, (int)0, (int)b.length, (int)0);
    }

    public static int relationOid(RelationInfo relationInfo) {
        Type t = Type.fromRelationType(relationInfo.relationType());
        return OidHash.oid(t.toString() + relationInfo.ident().fqn());
    }

    public static int relationOid(Type type, RelationName name) {
        return OidHash.oid(type.toString() + name.fqn());
    }

    public static int schemaOid(String name) {
        return OidHash.oid(String.valueOf((Object)Type.SCHEMA) + name);
    }

    public static int primaryKeyOid(RelationName name, List<ColumnIdent> primaryKeys) {
        String primaryKey = Lists.joinOn((String)" ", primaryKeys, ColumnIdent::name);
        return OidHash.oid(String.valueOf((Object)Type.PRIMARY_KEY) + name.fqn() + primaryKey);
    }

    public static int constraintOid(String relationName, String constraintName, String constraintType) {
        return OidHash.oid(String.valueOf((Object)Type.CONSTRAINT) + relationName + constraintName + constraintType);
    }

    public static int functionOid(Signature sig) {
        FunctionName name = sig.getName();
        return OidHash.oid(String.valueOf((Object)Type.PROC) + name.schema() + name.name() + OidHash.argTypesToStr(sig.getArgumentTypes()));
    }

    public static int publicationOid(String name, Publication publication) {
        String tables = Lists.joinOn((String)" ", publication.tables(), RelationName::fqn);
        return OidHash.oid(String.valueOf((Object)Type.PUBLICATION) + name + publication.owner() + tables);
    }

    public static int subscriptionOid(String name, Subscription subscription) {
        String publications = String.join((CharSequence)", ", subscription.publications());
        return OidHash.oid(String.valueOf((Object)Type.SUBSCRIPTION) + name + subscription.owner() + publications);
    }

    public static int userOid(String name) {
        return OidHash.oid(String.valueOf((Object)Type.USER) + name);
    }

    @VisibleForTesting
    static String argTypesToStr(List<TypeSignature> typeSignatures) {
        return Lists.joinOn((String)" ", typeSignatures, ts -> {
            try {
                return ts.createType().getName();
            }
            catch (IllegalArgumentException e) {
                String baseName = ts.getBaseTypeName();
                List<TypeSignature> innerTs = ts.getParameters();
                return baseName + (String)(innerTs.isEmpty() ? "" : "_" + OidHash.argTypesToStr(innerTs));
            }
        });
    }

    public static enum Type {
        SCHEMA,
        TABLE,
        VIEW,
        CONSTRAINT,
        PRIMARY_KEY,
        PROC,
        INDEX,
        USER,
        PUBLICATION,
        SUBSCRIPTION,
        HOST;


        public static Type fromRelationType(RelationInfo.RelationType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case RelationInfo.RelationType.BASE_TABLE, RelationInfo.RelationType.FOREIGN -> TABLE;
                case RelationInfo.RelationType.VIEW -> VIEW;
            };
        }
    }
}

