/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.execution.engine.collect.sources.InformationSchemaIterables;
import io.crate.expression.reference.StaticTableDefinition;
import io.crate.expression.reference.information.ColumnContext;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.metadata.pgcatalog.PgAmTable;
import io.crate.metadata.pgcatalog.PgAttrDefTable;
import io.crate.metadata.pgcatalog.PgAttributeTable;
import io.crate.metadata.pgcatalog.PgAuthMembersTable;
import io.crate.metadata.pgcatalog.PgCatalogSchemaInfo;
import io.crate.metadata.pgcatalog.PgClassTable;
import io.crate.metadata.pgcatalog.PgConstraintTable;
import io.crate.metadata.pgcatalog.PgCursors;
import io.crate.metadata.pgcatalog.PgDatabaseTable;
import io.crate.metadata.pgcatalog.PgDepend;
import io.crate.metadata.pgcatalog.PgDescriptionTable;
import io.crate.metadata.pgcatalog.PgEnumTable;
import io.crate.metadata.pgcatalog.PgEventTrigger;
import io.crate.metadata.pgcatalog.PgIndexTable;
import io.crate.metadata.pgcatalog.PgIndexesTable;
import io.crate.metadata.pgcatalog.PgLocksTable;
import io.crate.metadata.pgcatalog.PgMatviews;
import io.crate.metadata.pgcatalog.PgNamespaceTable;
import io.crate.metadata.pgcatalog.PgProcTable;
import io.crate.metadata.pgcatalog.PgRangeTable;
import io.crate.metadata.pgcatalog.PgRolesTable;
import io.crate.metadata.pgcatalog.PgSettingsTable;
import io.crate.metadata.pgcatalog.PgShdescriptionTable;
import io.crate.metadata.pgcatalog.PgStatsTable;
import io.crate.metadata.pgcatalog.PgTablesTable;
import io.crate.metadata.pgcatalog.PgTablespaceTable;
import io.crate.metadata.pgcatalog.PgTypeTable;
import io.crate.metadata.pgcatalog.PgViewsTable;
import io.crate.metadata.settings.session.NamedSessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.metadata.table.ConstraintInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.pgcatalog.PgPublicationTable;
import io.crate.replication.logical.metadata.pgcatalog.PgPublicationTablesTable;
import io.crate.replication.logical.metadata.pgcatalog.PgSubscriptionRelTable;
import io.crate.replication.logical.metadata.pgcatalog.PgSubscriptionTable;
import io.crate.role.GrantedRole;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.session.Cursor;
import io.crate.session.Sessions;
import io.crate.statistics.ColumnStatsEntry;
import io.crate.statistics.TableStats;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.inject.Inject;

public final class PgCatalogTableDefinitions {
    private final Map<RelationName, StaticTableDefinition<?>> tableDefinitions;

    @Inject
    public PgCatalogTableDefinitions(InformationSchemaIterables informationSchemaIterables, Sessions sessions, TableStats tableStats, PgCatalogSchemaInfo pgCatalogSchemaInfo, SessionSettingRegistry sessionSettingRegistry, NodeContext nodeContext, LogicalReplicationService logicalReplicationService, Roles roles) {
        Schemas schemas = nodeContext.schemas();
        Iterable subscriptionRows = () -> logicalReplicationService.subscriptions().entrySet().stream().map(e -> new PgSubscriptionTable.SubscriptionRow((String)e.getKey(), (Subscription)e.getValue())).iterator();
        Iterable publicationRows = () -> logicalReplicationService.publications().entrySet().stream().map(e -> new PgPublicationTable.PublicationRow((String)e.getKey(), (Publication)e.getValue())).iterator();
        Iterable docTableRelationNames = () -> InformationSchemaIterables.tablesStream(schemas).filter(x -> x instanceof DocTableInfo).map(RelationInfo::ident).iterator();
        Map.Entry[] entryArray = new Map.Entry[31];
        entryArray[0] = Map.entry(PgStatsTable.NAME, new StaticTableDefinition<ColumnStatsEntry>(() -> tableStats.statsEntries(docTableRelationNames), (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.relation().fqn()), PgStatsTable.INSTANCE.expressions()));
        entryArray[1] = Map.entry(PgTypeTable.IDENT, new StaticTableDefinition(() -> CompletableFuture.completedFuture(PGTypes.pgTypes()), PgTypeTable.INSTANCE.expressions(), false));
        entryArray[2] = Map.entry(PgClassTable.IDENT, new StaticTableDefinition<PgClassTable.Entry>(informationSchemaIterables::pgClasses, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.ident().fqn()) || roles.hasAnyPrivilege((Role)user, Securable.VIEW, t.ident().fqn()) || PgCatalogTableDefinitions.isPgCatalogOrInformationSchema(t.ident().schema()), pgCatalogSchemaInfo.pgClassTable().expressions()));
        entryArray[3] = Map.entry(PgProcTable.IDENT, new StaticTableDefinition<PgProcTable.Entry>(informationSchemaIterables::pgProc, (user, f) -> roles.hasAnyPrivilege((Role)user, Securable.SCHEMA, f.functionName.schema()) || f.functionName.isBuiltin(), PgProcTable.INSTANCE.expressions()));
        entryArray[4] = Map.entry(PgDatabaseTable.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.singletonList(null)), PgDatabaseTable.INSTANCE.expressions(), false));
        entryArray[5] = Map.entry(PgNamespaceTable.IDENT, new StaticTableDefinition<SchemaInfo>(informationSchemaIterables::schemas, (user, s) -> {
            if (roles.hasAnyPrivilege((Role)user, Securable.SCHEMA, s.name()) || PgCatalogTableDefinitions.isPgCatalogOrInformationSchema(s.name())) {
                return true;
            }
            for (TableInfo table : s.getTables()) {
                if (!roles.hasAnyPrivilege((Role)user, Securable.TABLE, table.ident().fqn())) continue;
                return true;
            }
            for (ViewInfo view : s.getViews()) {
                if (!roles.hasAnyPrivilege((Role)user, Securable.VIEW, view.ident().fqn())) continue;
                return true;
            }
            return false;
        }, PgNamespaceTable.INSTANCE.expressions()));
        entryArray[6] = Map.entry(PgAttrDefTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgAttrDefTable.INSTANCE.expressions(), false));
        entryArray[7] = Map.entry(PgAttributeTable.IDENT, new StaticTableDefinition<ColumnContext>(informationSchemaIterables::columns, (user, c) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, c.relation().ident().fqn()) || roles.hasAnyPrivilege((Role)user, Securable.VIEW, c.relation().ident().fqn()) || PgCatalogTableDefinitions.isPgCatalogOrInformationSchema(c.relation().ident().schema()), PgAttributeTable.INSTANCE.expressions()));
        entryArray[8] = Map.entry(PgIndexTable.IDENT, new StaticTableDefinition<PgIndexTable.Entry>(() -> CompletableFuture.completedFuture(informationSchemaIterables.pgIndices()), PgIndexTable.INSTANCE.expressions(), false));
        entryArray[9] = Map.entry(PgConstraintTable.IDENT, new StaticTableDefinition<ConstraintInfo>(informationSchemaIterables::pgConstraints, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.relationName().fqn()) || PgCatalogTableDefinitions.isPgCatalogOrInformationSchema(t.relationName().schema()), PgConstraintTable.INSTANCE.expressions()));
        entryArray[10] = Map.entry(PgDescriptionTable.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgDescriptionTable.INSTANCE.expressions(), false));
        entryArray[11] = Map.entry(PgRangeTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgRangeTable.INSTANCE.expressions(), false));
        entryArray[12] = Map.entry(PgEnumTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgEnumTable.INSTANCE.expressions(), false));
        entryArray[13] = Map.entry(PgRolesTable.IDENT, new StaticTableDefinition<Role>(() -> CompletableFuture.completedFuture(roles.roles()), PgRolesTable.create(roles).expressions(), false));
        entryArray[14] = Map.entry(PgAuthMembersTable.IDENT, new StaticTableDefinition<RoleMember>(() -> CompletableFuture.completedFuture(PgCatalogTableDefinitions.authMembers(roles.roles())), PgAuthMembersTable.create(roles).expressions(), false));
        entryArray[15] = Map.entry(PgAmTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgAmTable.INSTANCE.expressions(), false));
        entryArray[16] = Map.entry(PgTablespaceTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgTablespaceTable.INSTANCE.expressions(), false));
        entryArray[17] = Map.entry(PgSettingsTable.IDENT, new StaticTableDefinition<NamedSessionSetting>((txnCtx, role) -> CompletableFuture.completedFuture(sessionSettingRegistry.namedSessionSettings(txnCtx)), PgSettingsTable.INSTANCE.expressions(), false));
        entryArray[18] = Map.entry(PgIndexesTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgIndexesTable.INSTANCE.expressions(), false));
        entryArray[19] = Map.entry(PgLocksTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgLocksTable.INSTANCE.expressions(), false));
        entryArray[20] = Map.entry(PgPublicationTable.IDENT, new StaticTableDefinition<PgPublicationTable.PublicationRow>(() -> publicationRows, (user, p) -> p.owner().equals(user.name()), PgPublicationTable.INSTANCE.expressions()));
        entryArray[21] = Map.entry(PgPublicationTablesTable.IDENT, new StaticTableDefinition<PgPublicationTablesTable.PublicatedTableRow>(() -> PgPublicationTablesTable.rows(logicalReplicationService, schemas), (user, p) -> p.owner().equals(user.name()), PgPublicationTablesTable.INSTANCE.expressions()));
        entryArray[22] = Map.entry(PgSubscriptionTable.IDENT, new StaticTableDefinition<PgSubscriptionTable.SubscriptionRow>(() -> subscriptionRows, (user, s) -> s.subscription().owner().equals(user.name()), PgSubscriptionTable.INSTANCE.expressions()));
        entryArray[23] = Map.entry(PgSubscriptionRelTable.IDENT, new StaticTableDefinition<PgSubscriptionRelTable.PgSubscriptionRelRow>(() -> PgSubscriptionRelTable.rows(logicalReplicationService), (user, p) -> p.owner().equals(user.name()), PgSubscriptionRelTable.INSTANCE.expressions()));
        entryArray[24] = Map.entry(PgTablesTable.IDENT, new StaticTableDefinition<TableInfo>(informationSchemaIterables::tables, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.TABLE, t.ident().fqn()), PgTablesTable.INSTANCE.expressions()));
        entryArray[25] = Map.entry(PgViewsTable.IDENT, new StaticTableDefinition<ViewInfo>(informationSchemaIterables::views, (user, t) -> roles.hasAnyPrivilege((Role)user, Securable.VIEW, t.ident().fqn()), PgViewsTable.INSTANCE.expressions()));
        entryArray[26] = Map.entry(PgShdescriptionTable.IDENT, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgShdescriptionTable.INSTANCE.expressions(), false));
        entryArray[27] = Map.entry(PgCursors.IDENT, new StaticTableDefinition<Cursor>((transactionContext, user) -> CompletableFuture.completedFuture(sessions.getCursors(user)), PgCursors.INSTANCE.expressions(), false));
        entryArray[28] = Map.entry(PgEventTrigger.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgEventTrigger.INSTANCE.expressions(), false));
        entryArray[29] = Map.entry(PgDepend.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgDepend.INSTANCE.expressions(), false));
        entryArray[30] = Map.entry(PgMatviews.NAME, new StaticTableDefinition<Void>(() -> CompletableFuture.completedFuture(Collections.emptyList()), PgMatviews.INSTANCE.expressions(), false));
        this.tableDefinitions = Map.ofEntries(entryArray);
    }

    public StaticTableDefinition<?> get(RelationName relationName) {
        return this.tableDefinitions.get(relationName);
    }

    public static boolean isPgCatalogOrInformationSchema(String schemaName) {
        return "information_schema".equals(schemaName) || "pg_catalog".equals(schemaName);
    }

    public static boolean isPgCatalogOrInformationSchema(Integer schemaOid) {
        return OidHash.schemaOid("information_schema") == schemaOid || OidHash.schemaOid("pg_catalog") == schemaOid;
    }

    static Iterable<RoleMember> authMembers(Collection<Role> roles) {
        HashMap<String, Set> roleMembers = new HashMap<String, Set>();
        for (Role role : roles) {
            for (GrantedRole grantedRole : role.grantedRoles()) {
                roleMembers.computeIfAbsent(grantedRole.roleName(), string -> new HashSet()).add(new RoleMember(grantedRole.roleName(), role.name(), grantedRole.grantor()));
            }
        }
        return roleMembers.values().stream().flatMap(Collection::stream).toList();
    }

    public record RoleMember(String role, String member, String grantor) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleMember that = (RoleMember)o;
            return Objects.equals(this.role, that.role) && Objects.equals(this.member, that.member);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.role, this.member);
        }
    }
}

